/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.schemahistory;

import java.util.List;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.database.Schema;
import org.flywaydb.core.internal.schemahistory.AppliedMigration;
import org.flywaydb.core.internal.util.StringUtils;

public abstract class SchemaHistory {
    public abstract <T> T lock(Callable<T> var1);

    public abstract boolean exists();

    public abstract void create();

    public abstract boolean hasAppliedMigrations();

    public abstract List<AppliedMigration> allAppliedMigrations();

    public final void addBaselineMarker(MigrationVersion baselineVersion, String baselineDescription) {
        this.addAppliedMigration(baselineVersion, baselineDescription, MigrationType.BASELINE, baselineDescription, null, 0, true);
    }

    public abstract boolean hasBaselineMarker();

    public abstract AppliedMigration getBaselineMarker();

    public abstract void removeFailedMigrations();

    public abstract void addSchemasMarker(Schema[] var1);

    protected final void doAddSchemasMarker(Schema[] schemas) {
        this.addAppliedMigration(null, "<< Flyway Schema Creation >>", MigrationType.SCHEMA, StringUtils.arrayToCommaDelimitedString(schemas), null, 0, true);
    }

    public abstract boolean hasSchemasMarker();

    public abstract void update(AppliedMigration var1, ResolvedMigration var2);

    public void clearCache() {
    }

    public final void addAppliedMigration(MigrationVersion version, String description, MigrationType type, String script, Integer checksum, int executionTime, boolean success) {
        this.doAddAppliedMigration(version, this.abbreviateDescription(description), type, this.abbreviateScript(script), checksum, executionTime, success);
    }

    protected abstract void doAddAppliedMigration(MigrationVersion var1, String var2, MigrationType var3, String var4, Integer var5, int var6, boolean var7);

    private String abbreviateDescription(String description) {
        if (description == null) {
            return null;
        }
        if (description.length() <= 200) {
            return description;
        }
        return description.substring(0, 197) + "...";
    }

    private String abbreviateScript(String script) {
        if (script == null) {
            return null;
        }
        if (script.length() <= 1000) {
            return script;
        }
        return "..." + script.substring(3, 1000);
    }
}

