/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.info;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationInfoService;
import org.flywaydb.core.api.MigrationState;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.info.AppliedMigrationAttributes;
import org.flywaydb.core.internal.info.MigrationInfoContext;
import org.flywaydb.core.internal.info.MigrationInfoImpl;
import org.flywaydb.core.internal.schemahistory.AppliedMigration;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.util.ObjectUtils;
import org.flywaydb.core.internal.util.Pair;

public class MigrationInfoServiceImpl
implements MigrationInfoService {
    private final MigrationResolver migrationResolver;
    private final SchemaHistory schemaHistory;
    private MigrationVersion target;
    private boolean outOfOrder;
    private final boolean pending;
    private final boolean missing;
    private final boolean future;
    private List<MigrationInfoImpl> migrationInfos;

    public MigrationInfoServiceImpl(MigrationResolver migrationResolver, SchemaHistory schemaHistory, MigrationVersion target, boolean outOfOrder, boolean pending, boolean missing, boolean future) {
        this.migrationResolver = migrationResolver;
        this.schemaHistory = schemaHistory;
        this.target = target;
        this.outOfOrder = outOfOrder;
        this.pending = pending;
        this.missing = missing;
        this.future = future;
    }

    public void refresh() {
        Collection<ResolvedMigration> resolvedMigrations = this.migrationResolver.resolveMigrations();
        List<AppliedMigration> appliedMigrations = this.schemaHistory.allAppliedMigrations();
        MigrationInfoContext context = new MigrationInfoContext();
        context.outOfOrder = this.outOfOrder;
        context.pending = this.pending;
        context.missing = this.missing;
        context.future = this.future;
        context.target = this.target;
        TreeMap resolvedVersioned = new TreeMap();
        TreeMap<String, ResolvedMigration> resolvedRepeatable = new TreeMap<String, ResolvedMigration>();
        for (ResolvedMigration resolvedMigration : resolvedMigrations) {
            MigrationVersion version2 = resolvedMigration.getVersion();
            if (version2 != null) {
                if (version2.compareTo(context.lastResolved) > 0) {
                    context.lastResolved = version2;
                }
                resolvedVersioned.put(Pair.of(version2, false), resolvedMigration);
                continue;
            }
            resolvedRepeatable.put(resolvedMigration.getDescription(), resolvedMigration);
        }
        ArrayList<Pair<AppliedMigration, AppliedMigrationAttributes>> appliedVersioned = new ArrayList<Pair<AppliedMigration, AppliedMigrationAttributes>>();
        ArrayList<AppliedMigration> appliedRepeatable = new ArrayList<AppliedMigration>();
        for (AppliedMigration appliedMigration : appliedMigrations) {
            MigrationVersion migrationVersion = appliedMigration.getVersion();
            if (migrationVersion == null) {
                appliedRepeatable.add(appliedMigration);
                continue;
            }
            if (appliedMigration.getType() == MigrationType.SCHEMA) {
                context.schema = migrationVersion;
            }
            if (appliedMigration.getType() == MigrationType.BASELINE) {
                context.baseline = migrationVersion;
            }
            appliedVersioned.add(Pair.of(appliedMigration, new AppliedMigrationAttributes()));
        }
        for (Pair pair : appliedVersioned) {
            MigrationVersion migrationVersion = ((AppliedMigration)pair.getLeft()).getVersion();
            if (migrationVersion == null) continue;
            if (migrationVersion.compareTo(context.lastApplied) > 0) {
                context.lastApplied = migrationVersion;
                continue;
            }
            ((AppliedMigrationAttributes)pair.getRight()).outOfOrder = true;
        }
        if (MigrationVersion.CURRENT == this.target) {
            context.target = context.lastApplied;
        }
        HashSet allVersions = new HashSet(resolvedVersioned.keySet());
        for (Pair pair : appliedVersioned) {
            allVersions.add(Pair.of(((AppliedMigration)pair.getLeft()).getVersion(), false));
        }
        ArrayList<MigrationInfoImpl> arrayList = new ArrayList<MigrationInfoImpl>();
        HashSet hashSet = new HashSet(resolvedVersioned.values());
        for (Pair pair : appliedVersioned) {
            ResolvedMigration resolvedMigration = (ResolvedMigration)resolvedVersioned.get(Pair.of(((AppliedMigration)pair.getLeft()).getVersion(), ((AppliedMigration)pair.getLeft()).getType().isUndo()));
            if (resolvedMigration != null && ((AppliedMigration)pair.getLeft()).isSuccess()) {
                hashSet.remove(resolvedMigration);
            }
            arrayList.add(new MigrationInfoImpl(resolvedMigration, (AppliedMigration)pair.getLeft(), context, ((AppliedMigrationAttributes)pair.getRight()).outOfOrder));
        }
        for (ResolvedMigration resolvedMigration : hashSet) {
            arrayList.add(new MigrationInfoImpl(resolvedMigration, null, context, false));
        }
        for (AppliedMigration appliedMigration : appliedRepeatable) {
            if (context.latestRepeatableRuns.containsKey(appliedMigration.getDescription()) && appliedMigration.getInstalledRank() <= context.latestRepeatableRuns.get(appliedMigration.getDescription())) continue;
            context.latestRepeatableRuns.put(appliedMigration.getDescription(), appliedMigration.getInstalledRank());
        }
        HashSet pendingResolvedRepeatable = new HashSet(resolvedRepeatable.values());
        for (AppliedMigration appliedRepeatableMigration : appliedRepeatable) {
            ResolvedMigration resolvedMigration = (ResolvedMigration)resolvedRepeatable.get(appliedRepeatableMigration.getDescription());
            int latestRank = context.latestRepeatableRuns.get(appliedRepeatableMigration.getDescription());
            if (resolvedMigration != null && appliedRepeatableMigration.getInstalledRank() == latestRank && ObjectUtils.nullSafeEquals(appliedRepeatableMigration.getChecksum(), resolvedMigration.getChecksum())) {
                pendingResolvedRepeatable.remove(resolvedMigration);
            }
            arrayList.add(new MigrationInfoImpl(resolvedMigration, appliedRepeatableMigration, context, false));
        }
        for (ResolvedMigration prr : pendingResolvedRepeatable) {
            arrayList.add(new MigrationInfoImpl(prr, null, context, false));
        }
        Collections.sort(arrayList);
        this.migrationInfos = arrayList;
    }

    @Override
    public MigrationInfo[] all() {
        return this.migrationInfos.toArray(new MigrationInfoImpl[this.migrationInfos.size()]);
    }

    @Override
    public MigrationInfo current() {
        MigrationInfoImpl current = null;
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isApplied() || migrationInfo.getVersion() == null || current != null && migrationInfo.getVersion().compareTo(current.getVersion()) <= 0) continue;
            current = migrationInfo;
        }
        if (current != null) {
            return current;
        }
        for (int i = this.migrationInfos.size() - 1; i >= 0; --i) {
            MigrationInfoImpl migrationInfo;
            migrationInfo = this.migrationInfos.get(i);
            if (!migrationInfo.getState().isApplied()) continue;
            return migrationInfo;
        }
        return null;
    }

    public MigrationInfoImpl[] pending() {
        ArrayList<MigrationInfoImpl> pendingMigrations = new ArrayList<MigrationInfoImpl>();
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            if (MigrationState.PENDING != migrationInfo.getState()) continue;
            pendingMigrations.add(migrationInfo);
        }
        return pendingMigrations.toArray(new MigrationInfoImpl[pendingMigrations.size()]);
    }

    public MigrationInfoImpl[] applied() {
        ArrayList<MigrationInfoImpl> appliedMigrations = new ArrayList<MigrationInfoImpl>();
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isApplied()) continue;
            appliedMigrations.add(migrationInfo);
        }
        return appliedMigrations.toArray(new MigrationInfoImpl[appliedMigrations.size()]);
    }

    public MigrationInfo[] resolved() {
        ArrayList<MigrationInfo> resolvedMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isResolved()) continue;
            resolvedMigrations.add(migrationInfo);
        }
        return resolvedMigrations.toArray(new MigrationInfo[resolvedMigrations.size()]);
    }

    public MigrationInfo[] failed() {
        ArrayList<MigrationInfo> failedMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (!migrationInfo.getState().isFailed()) continue;
            failedMigrations.add(migrationInfo);
        }
        return failedMigrations.toArray(new MigrationInfo[failedMigrations.size()]);
    }

    public MigrationInfo[] future() {
        ArrayList<MigrationInfo> futureMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (migrationInfo.getState() != MigrationState.FUTURE_SUCCESS && migrationInfo.getState() != MigrationState.FUTURE_FAILED) continue;
            futureMigrations.add(migrationInfo);
        }
        return futureMigrations.toArray(new MigrationInfo[futureMigrations.size()]);
    }

    public MigrationInfo[] outOfOrder() {
        ArrayList<MigrationInfo> outOfOrderMigrations = new ArrayList<MigrationInfo>();
        for (MigrationInfo migrationInfo : this.migrationInfos) {
            if (migrationInfo.getState() != MigrationState.OUT_OF_ORDER) continue;
            outOfOrderMigrations.add(migrationInfo);
        }
        return outOfOrderMigrations.toArray(new MigrationInfo[outOfOrderMigrations.size()]);
    }

    public String validate() {
        for (MigrationInfoImpl migrationInfo : this.migrationInfos) {
            String message = migrationInfo.validate();
            if (message == null) continue;
            return message;
        }
        return null;
    }
}

