/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.redshift;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.FlywayConfiguration;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.SqlStatementBuilder;
import org.flywaydb.core.internal.database.redshift.RedshiftConnection;
import org.flywaydb.core.internal.database.redshift.RedshiftSqlStatementBuilder;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.core.internal.util.jdbc.JdbcTemplate;

public class RedshiftDatabase
extends Database<RedshiftConnection> {
    public static boolean isRedshift(Connection connection) {
        try {
            return new JdbcTemplate(connection).queryForString("SELECT version()", new String[0]).contains("Redshift");
        }
        catch (Exception e) {
            return false;
        }
    }

    public RedshiftDatabase(FlywayConfiguration configuration, Connection connection) {
        super(configuration, connection, 12);
    }

    @Override
    protected RedshiftConnection getConnection(Connection connection, int nullType) {
        return new RedshiftConnection(this.configuration, this, connection, nullType);
    }

    @Override
    protected final void ensureSupported() {
    }

    @Override
    public String getDbName() {
        return "redshift";
    }

    @Override
    protected String doGetCurrentUser() throws SQLException {
        return ((RedshiftConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT current_user", new String[0]);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "TRUE";
    }

    @Override
    public String getBooleanFalse() {
        return "FALSE";
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new RedshiftSqlStatementBuilder(this.getDefaultDelimiter());
    }

    @Override
    public String doQuote(String identifier) {
        return RedshiftDatabase.redshiftQuote(identifier);
    }

    static String redshiftQuote(String identifier) {
        return "\"" + StringUtils.replaceAll(identifier, "\"", "\"\"") + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }

    @Override
    public boolean useSingleConnection() {
        return false;
    }
}

