/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.MarkOccurrencesHighlightPainter;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;

class MarkOccurrencesSupport
implements CaretListener,
ActionListener {
    private RSyntaxTextArea textArea;
    private Timer timer;
    private MarkOccurrencesHighlightPainter p;
    private List tags;
    private static final int DEFAULT_DELAY_MS = 1000;

    public MarkOccurrencesSupport() {
        this(1000);
    }

    public MarkOccurrencesSupport(int n) {
        this(n, new Color(224, 224, 224));
    }

    public MarkOccurrencesSupport(int n, Color color) {
        this.timer = new Timer(n, this);
        this.timer.setRepeats(false);
        this.p = new MarkOccurrencesHighlightPainter();
        this.setColor(color);
        this.tags = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Caret caret = this.textArea.getCaret();
        if (caret.getDot() != caret.getMark()) {
            return;
        }
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.textArea.getDocument();
        rSyntaxDocument.readLock();
        try {
            this.removeHighlights();
            int n = this.textArea.getCaretLineNumber();
            Token token = this.textArea.getTokenListForLine(n);
            int n2 = caret.getDot();
            Token token2 = RSyntaxUtilities.getTokenAtOffset(token, n2);
            if (token2 == null || !this.isValidType(token2) || MarkOccurrencesSupport.isNonWordChar(token2)) {
                --n2;
                try {
                    if (n2 >= this.textArea.getLineStartOffset(n)) {
                        token2 = RSyntaxUtilities.getTokenAtOffset(token, n2);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
            if (token2 != null && this.isValidType(token2) && !MarkOccurrencesSupport.isNonWordChar(token2)) {
                RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
                String string = token2.getLexeme();
                int n3 = token2.type;
                for (int i = 0; i < this.textArea.getLineCount(); ++i) {
                    for (Token token3 = this.textArea.getTokenListForLine(i); token3 != null && token3.isPaintable(); token3 = token3.getNextToken()) {
                        if (token3.type != n3 || !token3.getLexeme().equals(string)) continue;
                        try {
                            int n4 = token3.offset + token3.textCount;
                            Object object = rSyntaxTextAreaHighlighter.addMarkedOccurrenceHighlight(token3.offset, n4, this.p);
                            this.tags.add(object);
                            continue;
                        }
                        catch (BadLocationException badLocationException) {
                            badLocationException.printStackTrace();
                        }
                    }
                }
            }
        }
        finally {
            rSyntaxDocument.readUnlock();
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        this.timer.restart();
    }

    public Color getColor() {
        return this.p.getColor();
    }

    public int getDelay() {
        return this.timer.getDelay();
    }

    public void install(RSyntaxTextArea rSyntaxTextArea) {
        if (this.textArea != null) {
            this.uninstall();
        }
        this.textArea = rSyntaxTextArea;
        rSyntaxTextArea.addCaretListener(this);
    }

    private static final boolean isNonWordChar(Token token) {
        return token.textCount == 1 && !RSyntaxUtilities.isLetter(token.text[token.textOffset]);
    }

    private boolean isValidType(Token token) {
        return this.textArea.getMarkOccurrencesOfTokenType(token.type);
    }

    private void removeHighlights() {
        if (this.textArea != null) {
            RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
            for (int i = 0; i < this.tags.size(); ++i) {
                rSyntaxTextAreaHighlighter.removeMarkOccurrencesHighlight(this.tags.get(i));
            }
        }
        this.tags.clear();
    }

    public void setColor(Color color) {
        this.p.setColor(color);
        if (this.textArea != null) {
            this.removeHighlights();
            this.caretUpdate(null);
        }
    }

    public void setDelay(int n) {
        this.timer.setDelay(n);
    }

    public void uninstall() {
        if (this.textArea != null) {
            this.removeHighlights();
            this.textArea.removeCaretListener(this);
        }
    }
}

