/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import java.util.List;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.netty4.Netty4Utils;

final class Netty4SizeHeaderFrameDecoder
extends ByteToMessageDecoder {
    Netty4SizeHeaderFrameDecoder() {
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        try {
            boolean continueProcessing = TcpTransport.validateMessageHeader((BytesReference)Netty4Utils.toBytesReference(in));
            ByteBuf message = in.skipBytes(6);
            if (!continueProcessing) {
                return;
            }
            out.add(message);
        }
        catch (IllegalArgumentException ex) {
            throw new TooLongFrameException((Throwable)ex);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

