/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.sparse.csc.decomposition.lu;

import org.ejml.UtilEjml;
import org.ejml.data.Complex_F64;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.IGrowArray;
import org.ejml.data.Matrix;
import org.ejml.interfaces.decomposition.LUSparseDecomposition_F64;
import org.ejml.sparse.ComputePermutation;
import org.ejml.sparse.csc.CommonOps_DSCC;
import org.ejml.sparse.csc.misc.ApplyFillReductionPermutation;
import org.ejml.sparse.csc.misc.TriangularSolver_DSCC;

public class LuUpLooking_DSCC
implements LUSparseDecomposition_F64<DMatrixSparseCSC> {
    private ApplyFillReductionPermutation applyReduce;
    private DMatrixSparseCSC L = new DMatrixSparseCSC(0, 0, 0);
    private DMatrixSparseCSC U = new DMatrixSparseCSC(0, 0, 0);
    private int[] pinv = new int[0];
    private double[] x = new double[0];
    private IGrowArray gxi = new IGrowArray();
    private IGrowArray gw = new IGrowArray();
    private boolean singular;

    public LuUpLooking_DSCC(ComputePermutation<DMatrixSparseCSC> reduceFill) {
        this.applyReduce = new ApplyFillReductionPermutation(reduceFill, false);
    }

    public boolean decompose(DMatrixSparseCSC A) {
        this.initialize(A);
        return this.performLU(this.applyReduce.apply(A));
    }

    private void initialize(DMatrixSparseCSC A) {
        int m = A.numRows;
        int n = A.numCols;
        int o = Math.min(m, n);
        this.L.reshape(m, m, 4 * A.nz_length + o);
        this.L.nz_length = 0;
        this.U.reshape(m, n, 4 * A.nz_length + o);
        this.U.nz_length = 0;
        this.singular = false;
        if (this.pinv.length != m) {
            this.pinv = new int[m];
            this.x = new double[m];
        }
        for (int i = 0; i < m; ++i) {
            this.pinv[i] = -1;
            this.L.col_idx[i] = 0;
        }
    }

    private boolean performLU(DMatrixSparseCSC A) {
        int m = A.numRows;
        int n = A.numCols;
        int[] q = this.applyReduce.getArrayP();
        int[] w = TriangularSolver_DSCC.adjust(this.gw, m * 2, m);
        for (int k = 0; k < n; ++k) {
            this.L.col_idx[k] = this.L.nz_length;
            this.U.col_idx[k] = this.U.nz_length;
            if (this.L.nz_length + n > this.L.nz_values.length) {
                this.L.growMaxLength(2 * this.L.nz_values.length + n, true);
            }
            if (this.U.nz_length + n > this.U.nz_values.length) {
                this.U.growMaxLength(2 * this.U.nz_values.length + n, true);
            }
            int col = q != null ? q[k] : k;
            int top = TriangularSolver_DSCC.solveColB(this.L, true, A, col, this.x, this.pinv, this.gxi, w);
            int[] xi = this.gxi.data;
            int ipiv = -1;
            double a = -1.7976931348623157E308;
            for (int p = top; p < n; ++p) {
                int i = xi[p];
                if (this.pinv[i] < 0) {
                    double d;
                    double t = Math.abs(this.x[i]);
                    if (!(d > a)) continue;
                    a = t;
                    ipiv = i;
                    continue;
                }
                this.U.nz_rows[this.U.nz_length] = this.pinv[i];
                this.U.nz_values[this.U.nz_length++] = this.x[i];
            }
            if (ipiv == -1 || a <= 0.0) {
                this.singular = true;
                return false;
            }
            double pivot = this.x[ipiv];
            this.U.nz_rows[this.U.nz_length] = k;
            this.U.nz_values[this.U.nz_length++] = pivot;
            this.pinv[ipiv] = k;
            this.L.nz_rows[this.L.nz_length] = ipiv;
            this.L.nz_values[this.L.nz_length++] = 1.0;
            for (int p = top; p < n; ++p) {
                int i = xi[p];
                if (this.pinv[i] < 0) {
                    this.L.nz_rows[this.L.nz_length] = i;
                    this.L.nz_values[this.L.nz_length++] = this.x[i] / pivot;
                }
                this.x[i] = 0.0;
            }
        }
        this.L.col_idx[n] = this.L.nz_length;
        this.U.col_idx[n] = this.U.nz_length;
        for (int p = 0; p < this.L.nz_length; ++p) {
            this.L.nz_rows[p] = this.pinv[this.L.nz_rows[p]];
        }
        return true;
    }

    public Complex_F64 computeDeterminant() {
        double value = UtilEjml.permutationSign((int[])this.pinv, (int)this.U.numCols, (int[])this.gw.data);
        for (int i = 0; i < this.U.numCols; ++i) {
            value *= this.U.nz_values[this.U.col_idx[i + 1] - 1];
        }
        return new Complex_F64(value, 0.0);
    }

    public DMatrixSparseCSC getLower(DMatrixSparseCSC lower) {
        if (lower == null) {
            lower = new DMatrixSparseCSC(1, 1, 0);
        }
        lower.set((Matrix)this.L);
        return lower;
    }

    public DMatrixSparseCSC getUpper(DMatrixSparseCSC upper) {
        if (upper == null) {
            upper = new DMatrixSparseCSC(1, 1, 0);
        }
        upper.set((Matrix)this.U);
        return upper;
    }

    public DMatrixSparseCSC getRowPivot(DMatrixSparseCSC pivot) {
        if (pivot == null) {
            pivot = new DMatrixSparseCSC(this.L.numRows, this.L.numRows, 0);
        }
        pivot.reshape(this.L.numRows, this.L.numRows, this.L.numRows);
        CommonOps_DSCC.permutationMatrix(this.pinv, true, this.L.numRows, pivot);
        return pivot;
    }

    public int[] getRowPivotV(IGrowArray pivot) {
        return UtilEjml.pivotVector((int[])this.pinv, (int)this.L.numRows, (IGrowArray)pivot);
    }

    public boolean isSingular() {
        return this.singular;
    }

    public boolean inputModified() {
        return false;
    }

    public IGrowArray getGxi() {
        return this.gxi;
    }

    public IGrowArray getGw() {
        return this.gw;
    }

    public int[] getPinv() {
        return this.pinv;
    }

    public DMatrixSparseCSC getL() {
        return this.L;
    }

    public DMatrixSparseCSC getU() {
        return this.U;
    }

    public ComputePermutation<DMatrixSparseCSC> getReduceFill() {
        return this.applyReduce.getFillReduce();
    }

    public int[] getReducePermutation() {
        return this.applyReduce.getArrayP();
    }

    public void setStructureLocked(boolean locked) {
        if (locked) {
            throw new RuntimeException("Can't lock a LU decomposition. Pivots change depending on numerical values and not justthe matrix's structure");
        }
    }

    public boolean isStructureLocked() {
        return false;
    }
}

