/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.data;

import org.ejml.data.CMatrixRMaj;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.ejml.data.DMatrixSparseTriplet;
import org.ejml.data.FMatrixRMaj;
import org.ejml.data.FMatrixSparseCSC;
import org.ejml.data.FMatrixSparseTriplet;
import org.ejml.data.Matrix;
import org.ejml.data.ZMatrixRMaj;

public enum MatrixType {
    DDRM(true, true, 64, DMatrixRMaj.class),
    FDRM(true, true, 32, FMatrixRMaj.class),
    ZDRM(false, true, 64, ZMatrixRMaj.class),
    CDRM(false, true, 32, CMatrixRMaj.class),
    DSCC(true, false, 64, DMatrixSparseCSC.class),
    FSCC(true, false, 32, FMatrixSparseCSC.class),
    ZSCC(false, false, 64, Object.class),
    CSCC(false, false, 32, Object.class),
    DTRIPLET(false, false, 64, DMatrixSparseTriplet.class),
    FTRIPLET(false, false, 64, FMatrixSparseTriplet.class),
    UNSPECIFIED(false, false, 0, Object.class);

    final boolean fixed;
    final boolean dense;
    final boolean real;
    final int bits;
    final Class<?> classType;

    private MatrixType(boolean real, boolean dense, int bits, Class<?> type) {
        this(false, real, dense, bits, type);
    }

    private MatrixType(boolean fixed, boolean real, boolean dense, int bits, Class<?> type) {
        this.real = real;
        this.fixed = fixed;
        this.dense = dense;
        this.bits = bits;
        this.classType = type;
    }

    public static MatrixType lookup(Class<?> type) {
        if (type == DMatrixRMaj.class) {
            return DDRM;
        }
        if (type == FMatrixRMaj.class) {
            return FDRM;
        }
        if (type == ZMatrixRMaj.class) {
            return ZDRM;
        }
        if (type == CMatrixRMaj.class) {
            return CDRM;
        }
        if (type == DMatrixSparseCSC.class) {
            return DSCC;
        }
        if (type == FMatrixSparseCSC.class) {
            return FSCC;
        }
        throw new IllegalArgumentException("Unknown class");
    }

    public static MatrixType lookup(boolean dense, boolean real, int bits) {
        if (dense) {
            if (real) {
                if (bits == 64) {
                    return DDRM;
                }
                return FDRM;
            }
            if (bits == 64) {
                return ZDRM;
            }
            return CDRM;
        }
        if (real) {
            if (bits == 64) {
                return DSCC;
            }
            return FSCC;
        }
        throw new IllegalArgumentException("Complex sparse not yet supported");
    }

    public boolean isReal() {
        return this.real;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isDense() {
        return this.dense;
    }

    public int getBits() {
        return this.bits;
    }

    public Class getClassType() {
        return this.classType;
    }

    public Matrix create(int rows, int cols) {
        switch (this) {
            case DDRM: {
                return new DMatrixRMaj(rows, cols);
            }
            case FDRM: {
                return new FMatrixRMaj(rows, cols);
            }
            case ZDRM: {
                return new ZMatrixRMaj(rows, cols);
            }
            case CDRM: {
                return new CMatrixRMaj(rows, cols);
            }
            case DSCC: {
                return new DMatrixSparseCSC(rows, cols);
            }
            case FSCC: {
                return new FMatrixSparseCSC(rows, cols);
            }
        }
        throw new RuntimeException("Unknown Matrix Type " + this);
    }
}

