/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory;

import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.sail.memory.model.MemIRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;
import org.eclipse.rdf4j.sail.memory.model.MemTriple;
import org.eclipse.rdf4j.sail.memory.model.MemValue;

class MemTripleIterator<X extends Exception>
extends LookAheadIteration<MemTriple, X> {
    private final MemStatementList statementList;
    private final MemResource subject;
    private final MemIRI predicate;
    private final MemValue object;
    private final int snapshot;
    private volatile int statementIdx;

    public MemTripleIterator(MemStatementList statementList, MemResource subject, MemIRI predicate, MemValue object, int snapshot) {
        this.statementList = statementList;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
        this.snapshot = snapshot;
        this.statementIdx = -1;
    }

    protected MemTriple getNextElement() {
        ++this.statementIdx;
        while (this.statementIdx < this.statementList.size()) {
            MemTriple triple;
            MemStatement st = this.statementList.get(this.statementIdx);
            if (this.isInSnapshot(st) && (st.getSubject() instanceof MemTriple ? this.matchesPattern(triple = (MemTriple)st.getSubject()) : st.getObject() instanceof MemTriple && this.matchesPattern(triple = (MemTriple)st.getObject()))) {
                return triple;
            }
            ++this.statementIdx;
        }
        return null;
    }

    private boolean matchesPattern(MemTriple triple) {
        if (this.subject != null && !this.subject.equals(triple.getSubject())) {
            return false;
        }
        if (this.predicate != null && !this.predicate.equals(triple.getPredicate())) {
            return false;
        }
        return this.object == null || this.object.equals(triple.getObject());
    }

    private boolean isInSnapshot(MemStatement st) {
        return this.snapshot < 0 || st.isInSnapshot(this.snapshot);
    }
}

