/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;

public class Load
extends AbstractQueryModelNode
implements UpdateExpr {
    private ValueConstant source;
    private ValueConstant graph;
    private boolean silent;

    public Load(ValueConstant source) {
        this.setSource(source);
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        if (this.source != null) {
            this.source.visit(visitor);
        }
        if (this.graph != null) {
            this.graph.visit(visitor);
        }
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.source == current) {
            this.setSource((ValueConstant)current);
        } else if (this.graph == current) {
            this.setGraph((ValueConstant)current);
        } else {
            super.replaceChildNode(current, replacement);
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Load) {
            Load o = (Load)other;
            return this.silent == o.silent && this.nullEquals(this.source, o.source) && this.nullEquals(this.graph, o.graph);
        }
        return false;
    }

    public int hashCode() {
        int result;
        int n = result = this.silent ? 1 : 0;
        if (this.source != null) {
            result ^= this.source.hashCode();
        }
        if (this.graph != null) {
            result ^= this.graph.hashCode();
        }
        return result;
    }

    @Override
    public Load clone() {
        Load clone = new Load(this.source.clone());
        clone.setSilent(this.isSilent());
        if (this.getGraph() != null) {
            clone.setGraph(this.getGraph().clone());
        }
        return clone;
    }

    public void setGraph(ValueConstant graph) {
        this.graph = graph;
    }

    public ValueConstant getGraph() {
        return this.graph;
    }

    public void setSource(ValueConstant source) {
        this.source = source;
    }

    public ValueConstant getSource() {
        return this.source;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }
}

