/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.signature;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.packager.rpm.RpmSignatureTag;
import org.eclipse.packager.rpm.Rpms;
import org.eclipse.packager.rpm.header.Header;
import org.eclipse.packager.rpm.signature.SignatureProcessor;

public final class SignatureProcessors {
    private SignatureProcessors() {
    }

    public static SignatureProcessor size() {
        return new SignatureProcessor(){
            private long headerSize;
            private long payloadSize;

            @Override
            public void feedHeader(ByteBuffer header) {
                this.headerSize = header.remaining();
            }

            @Override
            public void feedPayloadData(ByteBuffer data) {
                this.payloadSize += (long)data.remaining();
            }

            @Override
            public void finish(Header<RpmSignatureTag> signature) {
                signature.putSize(this.headerSize + this.payloadSize, RpmSignatureTag.SIZE, RpmSignatureTag.LONGSIZE);
            }
        };
    }

    public static SignatureProcessor payloadSize() {
        return new SignatureProcessor(){
            private long archiveSize;

            @Override
            public void init(long archiveSize) {
                this.archiveSize = archiveSize;
            }

            @Override
            public void feedHeader(ByteBuffer header) {
            }

            @Override
            public void feedPayloadData(ByteBuffer data) {
            }

            @Override
            public void finish(Header<RpmSignatureTag> signature) {
                signature.putSize(this.archiveSize, RpmSignatureTag.PAYLOAD_SIZE, RpmSignatureTag.LONGARCHIVESIZE);
            }
        };
    }

    public static SignatureProcessor sha256Header() {
        return new SignatureProcessor(){
            private String value;

            @Override
            public void feedHeader(ByteBuffer header) {
                try {
                    MessageDigest md = MessageDigest.getInstance("SHA-256");
                    md.update(header.slice());
                    this.value = Rpms.toHex(md.digest()).toLowerCase();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void feedPayloadData(ByteBuffer data) {
            }

            @Override
            public void finish(Header<RpmSignatureTag> signature) {
                signature.putString(RpmSignatureTag.SHA256HEADER, this.value);
            }
        };
    }

    public static SignatureProcessor sha1Header() {
        return new SignatureProcessor(){
            private String value;

            @Override
            public void feedHeader(ByteBuffer header) {
                try {
                    MessageDigest md = MessageDigest.getInstance("SHA1");
                    md.update(header.slice());
                    this.value = Rpms.toHex(md.digest()).toLowerCase();
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void feedPayloadData(ByteBuffer data) {
            }

            @Override
            public void finish(Header<RpmSignatureTag> signature) {
                signature.putString(RpmSignatureTag.SHA1HEADER, this.value);
            }
        };
    }

    public static SignatureProcessor md5() {
        return new SignatureProcessor(){
            private MessageDigest digest;

            @Override
            public void init(long archiveSize) {
                try {
                    this.digest = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void feedHeader(ByteBuffer header) {
                this.digest.update(header);
            }

            @Override
            public void feedPayloadData(ByteBuffer data) {
                this.digest.update(data);
            }

            @Override
            public void finish(Header<RpmSignatureTag> signature) {
                signature.putBlob(RpmSignatureTag.MD5, this.digest.digest());
            }
        };
    }
}

