/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Utf8Appendable;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BadPayloadException;
import org.eclipse.jetty.websocket.api.ProtocolException;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.WebSocketFrame;

public class CloseInfo {
    private static final Logger LOG = Log.getLogger(CloseInfo.class);
    private int statusCode;
    private String reason;

    public CloseInfo() {
        this(1005, null);
    }

    public CloseInfo(ByteBuffer payload, boolean validate) {
        this.statusCode = 1005;
        this.reason = null;
        if (payload == null || payload.remaining() == 0) {
            return;
        }
        ByteBuffer data = payload.slice();
        if (data.remaining() == 1 && validate) {
            throw new ProtocolException("Invalid 1 byte payload");
        }
        if (data.remaining() >= 2) {
            this.statusCode = 0;
            this.statusCode |= (data.get() & 0xFF) << 8;
            this.statusCode |= data.get() & 0xFF;
            if (validate && (this.statusCode < 1000 || this.statusCode == 1004 || this.statusCode == 1006 || this.statusCode == 1005 || this.statusCode > 1011 && this.statusCode <= 2999 || this.statusCode >= 5000)) {
                throw new ProtocolException("Invalid close code: " + this.statusCode);
            }
            if (data.remaining() > 0) {
                try {
                    Utf8StringBuilder utf = new Utf8StringBuilder();
                    utf.append(data);
                    this.reason = utf.toString();
                }
                catch (Utf8Appendable.NotUtf8Exception e) {
                    if (validate) {
                        throw new BadPayloadException("Invalid Close Reason", (Throwable)e);
                    }
                    LOG.warn((Throwable)e);
                }
                catch (RuntimeException e) {
                    if (validate) {
                        throw new ProtocolException("Invalid Close Reason", (Throwable)e);
                    }
                    LOG.warn((Throwable)e);
                }
            }
        }
    }

    public CloseInfo(Frame frame) {
        this(frame.getPayload(), false);
    }

    public CloseInfo(Frame frame, boolean validate) {
        this(frame.getPayload(), validate);
    }

    public CloseInfo(int statusCode) {
        this(statusCode, null);
    }

    public CloseInfo(int statusCode, String reason) {
        this.statusCode = statusCode;
        this.reason = reason;
    }

    private byte[] asByteBuffer() {
        if (this.statusCode == 1006 || this.statusCode == 1005 || this.statusCode == -1) {
            return null;
        }
        int len = 2;
        byte[] utf = null;
        if (StringUtil.isNotBlank((String)this.reason)) {
            utf = StringUtil.getUtf8Bytes((String)this.reason);
            len += utf.length;
        }
        byte[] buf = new byte[len];
        buf[0] = (byte)(this.statusCode >>> 8 & 0xFF);
        buf[1] = (byte)(this.statusCode >>> 0 & 0xFF);
        if (utf != null) {
            System.arraycopy(utf, 0, buf, 2, utf.length);
        }
        return buf;
    }

    public WebSocketFrame asFrame() {
        WebSocketFrame frame = new WebSocketFrame(8);
        frame.setFin(true);
        frame.setPayload(this.asByteBuffer());
        return frame;
    }

    public String getReason() {
        return this.reason;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean isHarsh() {
        return this.statusCode != 1000 && this.statusCode != 1005;
    }

    public String toString() {
        return String.format("CloseInfo[code=%d,reason=%s]", this.statusCode, this.reason);
    }
}

