/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.util.List;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebXmlProcessor;

public class FragmentConfiguration
implements Configuration {
    public static final String FRAGMENT_RESOURCES = "org.eclipse.jetty.webFragments";

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        if (!context.isConfigurationDiscovered()) {
            return;
        }
        WebXmlProcessor processor = (WebXmlProcessor)context.getAttribute("org.eclipse.jetty.webProcessor");
        if (processor == null) {
            processor = new WebXmlProcessor(context);
            context.setAttribute("org.eclipse.jetty.webProcessor", processor);
        }
        this.parseWebFragments(context, processor);
    }

    @Override
    public void configure(WebAppContext context) throws Exception {
        if (!context.isConfigurationDiscovered()) {
            return;
        }
        WebXmlProcessor processor = (WebXmlProcessor)context.getAttribute("org.eclipse.jetty.webProcessor");
        if (processor == null) {
            processor = new WebXmlProcessor(context);
            context.setAttribute("org.eclipse.jetty.webProcessor", processor);
        }
        processor.orderFragments();
        processor.processFragments();
    }

    @Override
    public void deconfigure(WebAppContext context) throws Exception {
    }

    @Override
    public void postConfigure(WebAppContext context) throws Exception {
        context.setAttribute(FRAGMENT_RESOURCES, null);
    }

    public void parseWebFragments(WebAppContext context, WebXmlProcessor processor) throws Exception {
        List frags = (List)context.getAttribute(FRAGMENT_RESOURCES);
        if (frags != null) {
            for (Resource frag : frags) {
                processor.parseFragment(Resource.newResource((String)("jar:" + frag.getURL() + "!/META-INF/web-fragment.xml")));
            }
        }
    }
}

