/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.ByteBufferHttpInput;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.BlockingCallback;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpConnection
extends AbstractConnection
implements Runnable,
HttpTransport {
    public static final String UPGRADE_CONNECTION_ATTRIBUTE = "org.eclipse.jetty.server.HttpConnection.UPGRADE";
    private static final boolean REQUEST_BUFFER_DIRECT = false;
    private static final boolean HEADER_BUFFER_DIRECT = false;
    private static final boolean CHUNK_BUFFER_DIRECT = false;
    private static final Logger LOG = Log.getLogger(HttpConnection.class);
    private static final ThreadLocal<HttpConnection> __currentConnection = new ThreadLocal();
    private final HttpConfiguration _config;
    private final Connector _connector;
    private final ByteBufferPool _bufferPool;
    private final HttpGenerator _generator;
    private final HttpChannelOverHttp _channel;
    private final HttpParser _parser;
    private volatile ByteBuffer _requestBuffer = null;
    private volatile ByteBuffer _chunk = null;
    private BlockingCallback _readBlocker = new BlockingCallback();
    private BlockingCallback _writeBlocker = new BlockingCallback();

    public static HttpConnection getCurrentConnection() {
        return __currentConnection.get();
    }

    protected static void setCurrentConnection(HttpConnection connection) {
        __currentConnection.set(connection);
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._config;
    }

    public HttpConnection(HttpConfiguration config, Connector connector, EndPoint endPoint) {
        super(endPoint, connector.getExecutor(), true);
        this._config = config;
        this._connector = connector;
        this._bufferPool = this._connector.getByteBufferPool();
        this._generator = new HttpGenerator();
        this._generator.setSendServerVersion(this._config.getSendServerVersion());
        this._channel = new HttpChannelOverHttp(connector, config, endPoint, this, new Input());
        this._parser = this.newHttpParser();
        LOG.debug("New HTTP Connection {}", new Object[]{this});
    }

    protected HttpParser newHttpParser() {
        return new HttpParser(this.newRequestHandler(), this.getHttpConfiguration().getRequestHeaderSize());
    }

    protected HttpParser.RequestHandler<ByteBuffer> newRequestHandler() {
        return this._channel;
    }

    public Server getServer() {
        return this._connector.getServer();
    }

    public Connector getConnector() {
        return this._connector;
    }

    public HttpChannel<?> getHttpChannel() {
        return this._channel;
    }

    public void reset() {
        if (this._channel.isExpecting100Continue()) {
            this._parser.reset();
            this._parser.close();
        } else if (this._generator.isPersistent()) {
            this._parser.reset();
        } else {
            this._parser.close();
        }
        this._generator.reset();
        this._channel.reset();
        this.releaseRequestBuffer();
        if (this._chunk != null) {
            this._bufferPool.release(this._chunk);
            this._chunk = null;
        }
    }

    public int getMessagesIn() {
        return this.getHttpChannel().getRequests();
    }

    public int getMessagesOut() {
        return this.getHttpChannel().getRequests();
    }

    public String toString() {
        return String.format("%s,g=%s,p=%s", super.toString(), this._generator, this._parser);
    }

    private void releaseRequestBuffer() {
        if (this._requestBuffer != null && !this._requestBuffer.hasRemaining()) {
            ByteBuffer buffer = this._requestBuffer;
            this._requestBuffer = null;
            this._bufferPool.release(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onFillable() {
        LOG.debug("{} onFillable {}", new Object[]{this, this._channel.getState()});
        HttpConnection.setCurrentConnection(this);
        try {
            while (true) {
                boolean call_channel;
                if (!(call_channel = this._parser.parseNext(this._requestBuffer == null ? BufferUtil.EMPTY_BUFFER : this._requestBuffer))) {
                    int filled;
                    if (!BufferUtil.isEmpty((ByteBuffer)this._requestBuffer)) {
                        LOG.warn("Unexpected state: " + this + " " + this._channel + " " + this._channel.getRequest(), new Object[0]);
                        if (this._channel.getState().isSuspended()) return;
                        this.getEndPoint().close();
                        return;
                    }
                    if (this._requestBuffer == null) {
                        this._requestBuffer = this._bufferPool.acquire(this.getInputBufferSize(), false);
                    }
                    if ((filled = this.getEndPoint().fill(this._requestBuffer)) == 0) {
                        filled = this.getEndPoint().fill(this._requestBuffer);
                    }
                    LOG.debug("{} filled {}", new Object[]{this, filled});
                    if (filled == 0) {
                        this.releaseRequestBuffer();
                        this.fillInterested();
                        return;
                    }
                    if (filled < 0) {
                        this._parser.shutdownInput();
                        if (this.getEndPoint().isOutputShutdown()) {
                            this.getEndPoint().close();
                        } else {
                            this.getEndPoint().shutdownOutput();
                        }
                        this.releaseRequestBuffer();
                        return;
                    }
                } else {
                    while (this._parser.inContentState() && this._parser.parseNext(this._requestBuffer == null ? BufferUtil.EMPTY_BUFFER : this._requestBuffer)) {
                    }
                    boolean handle = this._channel.handle();
                    if (!handle) return;
                    if (this.getEndPoint().getConnection() != this) {
                        return;
                    }
                }
                continue;
                break;
            }
        }
        catch (EofException e) {
            LOG.debug((Throwable)e);
            return;
        }
        catch (Exception e) {
            if (this._parser.isIdle()) {
                LOG.debug((Throwable)e);
            } else {
                LOG.warn(this.toString(), (Throwable)e);
            }
            this.close();
            return;
        }
        finally {
            HttpConnection.setCurrentConnection(null);
        }
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    @Override
    public void run() {
        this.onFillable();
    }

    @Override
    public void send(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean lastContent) throws IOException {
        try {
            if (info == null) {
                new ContentCallback(content, lastContent, (Callback)this._writeBlocker).iterate();
            } else {
                if (this._channel.isExpecting100Continue()) {
                    this._generator.setPersistent(false);
                }
                new CommitCallback(info, content, lastContent, (Callback)this._writeBlocker).iterate();
            }
            this._writeBlocker.block();
        }
        catch (ClosedChannelException e) {
            throw new EofException((Throwable)e);
        }
        catch (IOException e) {
            throw e;
        }
    }

    @Override
    public void send(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean lastContent, Callback callback) {
        if (info == null) {
            new ContentCallback(content, lastContent, callback).iterate();
        } else {
            if (this._channel.isExpecting100Continue()) {
                this._generator.setPersistent(false);
            }
            new CommitCallback(info, content, lastContent, callback).iterate();
        }
    }

    @Override
    public void send(ByteBuffer content, boolean lastContent, Callback callback) {
        new ContentCallback(content, lastContent, callback).iterate();
    }

    @Override
    public void completed() {
        Connection connection;
        if (this._parser.isInContent() && this._generator.isPersistent() && !this._channel.isExpecting100Continue()) {
            this._channel.getRequest().getHttpInput().consumeAll();
        }
        if (this._channel.getResponse().getStatus() == 101 && (connection = (Connection)this._channel.getRequest().getAttribute(UPGRADE_CONNECTION_ATTRIBUTE)) != null) {
            LOG.debug("Upgrade from {} to {}", new Object[]{this, connection});
            this.onClose();
            this.getEndPoint().setConnection(connection);
            connection.onOpen();
            this.reset();
            return;
        }
        this.reset();
        if (HttpConnection.getCurrentConnection() != this && this._parser.isStart()) {
            if (this._requestBuffer == null) {
                this.fillInterested();
            } else if (this.getConnector().isStarted()) {
                LOG.debug("{} pipelined", new Object[]{this});
                try {
                    this.getExecutor().execute(this);
                }
                catch (RejectedExecutionException e) {
                    if (this.getConnector().isStarted()) {
                        LOG.warn((Throwable)e);
                    } else {
                        LOG.ignore((Throwable)e);
                    }
                    this.getEndPoint().close();
                }
            } else {
                this.getEndPoint().close();
            }
        }
    }

    public ByteBuffer getRequestBuffer() {
        return this._requestBuffer;
    }

    private class ContentCallback
    extends IteratingCallback {
        final ByteBuffer _content;
        final boolean _lastContent;

        ContentCallback(ByteBuffer content, boolean last, Callback callback) {
            super(callback);
            this._content = content;
            this._lastContent = last;
        }

        public boolean process() throws Exception {
            HttpGenerator.Result result;
            ByteBuffer chunk = HttpConnection.this._chunk;
            block8: while (true) {
                result = HttpConnection.this._generator.generateResponse(null, null, chunk, this._content, this._lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} generate: {} ({},{})@{}", new Object[]{this, result, BufferUtil.toSummaryString((ByteBuffer)this._content), this._lastContent, HttpConnection.this._generator.getState()});
                }
                switch (result) {
                    case NEED_HEADER: {
                        throw new IllegalStateException();
                    }
                    case NEED_CHUNK: {
                        chunk = HttpConnection.this._chunk = HttpConnection.this._bufferPool.acquire(12, false);
                        continue block8;
                    }
                    case FLUSH: {
                        if (HttpConnection.this._channel.getRequest().isHead()) {
                            BufferUtil.clear((ByteBuffer)chunk);
                            BufferUtil.clear((ByteBuffer)this._content);
                            continue block8;
                        }
                        if (BufferUtil.hasContent((ByteBuffer)chunk)) {
                            if (BufferUtil.hasContent((ByteBuffer)this._content)) {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{chunk, this._content});
                            } else {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{chunk});
                            }
                        } else {
                            if (!BufferUtil.hasContent((ByteBuffer)this._content)) continue block8;
                            HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._content});
                        }
                        return false;
                    }
                    case SHUTDOWN_OUT: {
                        HttpConnection.this.getEndPoint().shutdownOutput();
                        continue block8;
                    }
                    case DONE: {
                        return true;
                    }
                    case CONTINUE: {
                        continue block8;
                    }
                }
                break;
            }
            throw new IllegalStateException("generateResponse=" + result);
        }
    }

    private class CommitCallback
    extends IteratingCallback {
        final ByteBuffer _content;
        final boolean _lastContent;
        final HttpGenerator.ResponseInfo _info;
        ByteBuffer _header;

        CommitCallback(HttpGenerator.ResponseInfo info, ByteBuffer content, boolean last, Callback callback) {
            super(callback);
            this._info = info;
            this._content = content;
            this._lastContent = last;
        }

        public boolean process() throws Exception {
            HttpGenerator.Result result;
            ByteBuffer chunk = HttpConnection.this._chunk;
            block8: while (true) {
                result = HttpConnection.this._generator.generateResponse(this._info, this._header, chunk, this._content, this._lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} generate: {} ({},{},{})@{}", new Object[]{this, result, BufferUtil.toSummaryString((ByteBuffer)this._header), BufferUtil.toSummaryString((ByteBuffer)this._content), this._lastContent, HttpConnection.this._generator.getState()});
                }
                switch (result) {
                    case NEED_HEADER: {
                        if (this._lastContent && this._content != null && BufferUtil.space((ByteBuffer)this._content) > HttpConnection.this._config.getResponseHeaderSize() && this._content.hasArray()) {
                            int p = this._content.position();
                            int l = this._content.limit();
                            this._content.position(l);
                            this._content.limit(l + HttpConnection.this._config.getResponseHeaderSize());
                            this._header = this._content.slice();
                            this._header.limit(0);
                            this._content.position(p);
                            this._content.limit(l);
                            continue block8;
                        }
                        this._header = HttpConnection.this._bufferPool.acquire(HttpConnection.this._config.getResponseHeaderSize(), false);
                        continue block8;
                    }
                    case NEED_CHUNK: {
                        chunk = HttpConnection.this._chunk = HttpConnection.this._bufferPool.acquire(12, false);
                        continue block8;
                    }
                    case FLUSH: {
                        if (HttpConnection.this._channel.getRequest().isHead()) {
                            BufferUtil.clear((ByteBuffer)chunk);
                            BufferUtil.clear((ByteBuffer)this._content);
                        }
                        if (BufferUtil.hasContent((ByteBuffer)this._header)) {
                            if (BufferUtil.hasContent((ByteBuffer)this._content)) {
                                if (BufferUtil.hasContent((ByteBuffer)chunk)) {
                                    HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._header, chunk, this._content});
                                } else {
                                    HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._header, this._content});
                                }
                            } else {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._header});
                            }
                        } else if (BufferUtil.hasContent((ByteBuffer)chunk)) {
                            if (BufferUtil.hasContent((ByteBuffer)this._content)) {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{chunk, this._content});
                            } else {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{chunk});
                            }
                        } else {
                            if (!BufferUtil.hasContent((ByteBuffer)this._content)) continue block8;
                            HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._content});
                        }
                        return false;
                    }
                    case SHUTDOWN_OUT: {
                        HttpConnection.this.getEndPoint().shutdownOutput();
                        continue block8;
                    }
                    case DONE: {
                        if (!(this._header == null || this._lastContent && this._content != null && this._content.hasArray() && this._header.hasArray() && this._content.array() == this._header.array())) {
                            HttpConnection.this._bufferPool.release(this._header);
                        }
                        return true;
                    }
                    case CONTINUE: {
                        continue block8;
                    }
                }
                break;
            }
            throw new IllegalStateException("generateResponse=" + result);
        }
    }

    private class HttpChannelOverHttp
    extends HttpChannel<ByteBuffer> {
        public HttpChannelOverHttp(Connector connector, HttpConfiguration config, EndPoint endPoint, HttpTransport transport, HttpInput<ByteBuffer> input) {
            super(connector, config, endPoint, transport, input);
        }

        @Override
        public void badMessage(int status, String reason) {
            HttpConnection.this._generator.setPersistent(false);
            super.badMessage(status, reason);
        }

        @Override
        public boolean headerComplete() {
            boolean persistent;
            HttpVersion version = this.getHttpVersion();
            switch (version) {
                case HTTP_0_9: {
                    persistent = false;
                    break;
                }
                case HTTP_1_0: {
                    persistent = this.getRequest().getHttpFields().contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString());
                    if (!persistent) {
                        persistent = HttpMethod.CONNECT.is(this.getRequest().getMethod());
                    }
                    if (!persistent) break;
                    this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE);
                    break;
                }
                case HTTP_1_1: {
                    boolean bl = persistent = !this.getRequest().getHttpFields().contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString());
                    if (!persistent) {
                        persistent = HttpMethod.CONNECT.is(this.getRequest().getMethod());
                    }
                    if (persistent) break;
                    this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (!persistent) {
                HttpConnection.this._generator.setPersistent(false);
            }
            return super.headerComplete();
        }

        @Override
        protected void handleException(Throwable x) {
            HttpConnection.this._generator.setPersistent(false);
            super.handleException(x);
        }

        @Override
        public void failed() {
            this.getEndPoint().shutdownOutput();
        }
    }

    private class Input
    extends ByteBufferHttpInput {
        private Input() {
        }

        @Override
        protected void blockForContent() throws IOException {
            while (!HttpConnection.this._parser.isComplete()) {
                boolean event = HttpConnection.this._parser.parseNext(HttpConnection.this._requestBuffer == null ? BufferUtil.EMPTY_BUFFER : HttpConnection.this._requestBuffer);
                while (!event && BufferUtil.hasContent((ByteBuffer)HttpConnection.this._requestBuffer) && HttpConnection.this._parser.inContentState()) {
                    event = HttpConnection.this._parser.parseNext(HttpConnection.this._requestBuffer);
                }
                if (HttpConnection.this._parser.isComplete() || this.available() > 0) {
                    return;
                }
                if (!BufferUtil.isEmpty((ByteBuffer)HttpConnection.this._requestBuffer)) continue;
                if (HttpConnection.this.getEndPoint().isInputShutdown()) {
                    HttpConnection.this._parser.shutdownInput();
                    this.shutdown();
                    return;
                }
                HttpConnection.this.block(HttpConnection.this._readBlocker);
                LOG.debug("{} block readable on {}", new Object[]{this, HttpConnection.this._readBlocker});
                HttpConnection.this._readBlocker.block();
                if (HttpConnection.this._requestBuffer == null) {
                    long content_length = HttpConnection.this._channel.getRequest().getContentLength();
                    int size = HttpConnection.this.getInputBufferSize();
                    if ((long)size < content_length) {
                        size *= 4;
                    }
                    HttpConnection.this._requestBuffer = HttpConnection.this._bufferPool.acquire(size, false);
                }
                int filled = HttpConnection.this.getEndPoint().fill(HttpConnection.this._requestBuffer);
                LOG.debug("{} block filled {}", new Object[]{this, filled});
                if (filled >= 0) continue;
                HttpConnection.this._parser.shutdownInput();
                return;
            }
        }

        @Override
        protected void onContentQueued(ByteBuffer ref) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void earlyEOF() {
            Object object = this.lock();
            synchronized (object) {
                this._inputEOF = true;
                this._earlyEOF = true;
                LOG.debug("{} early EOF", new Object[]{this});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            Object object = this.lock();
            synchronized (object) {
                this._inputEOF = true;
                LOG.debug("{} shutdown", new Object[]{this});
            }
        }

        @Override
        protected void onAllContentConsumed() {
            HttpConnection.this.releaseRequestBuffer();
        }

        public String toString() {
            return super.toString() + "{" + HttpConnection.this._channel + "," + HttpConnection.this + "}";
        }
    }
}

