/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ShutdownHandler
extends AbstractHandler {
    private static final Logger LOG = Log.getLogger(ShutdownHandler.class);
    private final String _shutdownToken;
    private final Server _server;
    private boolean _exitJvm = false;

    public ShutdownHandler(Server server, String shutdownToken) {
        this._server = server;
        this._shutdownToken = shutdownToken;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!target.equals("/shutdown")) {
            return;
        }
        if (!request.getMethod().equals("POST")) {
            response.sendError(400);
            return;
        }
        if (!this.hasCorrectSecurityToken(request)) {
            LOG.warn("Unauthorized shutdown attempt from " + this.getRemoteAddr(request), new Object[0]);
            response.sendError(401);
            return;
        }
        if (!this.requestFromLocalhost(request)) {
            LOG.warn("Unauthorized shutdown attempt from " + this.getRemoteAddr(request), new Object[0]);
            response.sendError(401);
            return;
        }
        LOG.info("Shutting down by request from " + this.getRemoteAddr(request), new Object[0]);
        new Thread(){

            @Override
            public void run() {
                try {
                    ShutdownHandler.this.shutdownServer();
                }
                catch (InterruptedException e) {
                    LOG.ignore((Throwable)e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Shutting down server", e);
                }
            }
        }.start();
    }

    private boolean requestFromLocalhost(HttpServletRequest request) {
        return "127.0.0.1".equals(this.getRemoteAddr(request));
    }

    protected String getRemoteAddr(HttpServletRequest request) {
        return request.getRemoteAddr();
    }

    private boolean hasCorrectSecurityToken(HttpServletRequest request) {
        String tok = request.getParameter("token");
        LOG.debug("Token: {}", new Object[]{tok});
        return this._shutdownToken.equals(tok);
    }

    private void shutdownServer() throws Exception {
        this._server.stop();
        if (this._exitJvm) {
            System.exit(0);
        }
    }

    public void setExitJvm(boolean exitJvm) {
        this._exitJvm = exitJvm;
    }
}

