/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class HttpChannelState {
    private static final Logger LOG = Log.getLogger(HttpChannelState.class);
    private static final long DEFAULT_TIMEOUT = 30000L;
    private final HttpChannel<?> _channel;
    private List<AsyncListener> _lastAsyncListeners;
    private List<AsyncListener> _asyncListeners;
    private State _state;
    private boolean _initial;
    private boolean _dispatched;
    private boolean _expired;
    private volatile boolean _responseWrapped;
    private long _timeoutMs = 30000L;
    private AsyncContextEvent _event;

    protected HttpChannelState(HttpChannel<?> channel) {
        this._channel = channel;
        this._state = State.IDLE;
        this._initial = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AsyncListener listener) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._asyncListeners == null) {
                this._asyncListeners = new ArrayList<AsyncListener>();
            }
            this._asyncListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(long ms) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            this._timeoutMs = ms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeout() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._timeoutMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncContextEvent getAsyncContextEvent() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._event;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return super.toString() + "@" + this.getStatusString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatusString() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return (Object)((Object)this._state) + (this._initial ? ",initial" : "") + (this._dispatched ? ",resumed" : "") + (this._expired ? ",expired" : "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Next handling() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case IDLE: {
                    this._initial = true;
                    this._state = State.DISPATCHED;
                    if (this._lastAsyncListeners != null) {
                        this._lastAsyncListeners.clear();
                    }
                    if (this._asyncListeners != null) {
                        this._asyncListeners.clear();
                        break;
                    }
                    this._asyncListeners = this._lastAsyncListeners;
                    this._lastAsyncListeners = null;
                    break;
                }
                case COMPLETECALLED: {
                    this._state = State.COMPLETING;
                    return Next.COMPLETE;
                }
                case COMPLETING: {
                    return Next.COMPLETE;
                }
                case ASYNCWAIT: {
                    return Next.WAIT;
                }
                case COMPLETED: {
                    return Next.RECYCLE;
                }
                case REDISPATCH: {
                    this._state = State.REDISPATCHED;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
            this._responseWrapped = false;
            return Next.CONTINUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAsync(AsyncContextEvent event) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case DISPATCHED: 
                case REDISPATCHED: {
                    this._dispatched = false;
                    this._expired = false;
                    this._responseWrapped = event.getSuppliedResponse() != this._channel.getResponse();
                    this._responseWrapped = false;
                    this._event = event;
                    this._state = State.ASYNCSTARTED;
                    List<AsyncListener> listeners = this._lastAsyncListeners;
                    this._lastAsyncListeners = this._asyncListeners;
                    if (listeners != null) {
                        listeners.clear();
                    }
                    this._asyncListeners = listeners;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (this._lastAsyncListeners != null) {
            for (AsyncListener listener : this._lastAsyncListeners) {
                try {
                    listener.onStartAsync((AsyncEvent)this._event);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void error(Throwable th) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._event != null) {
                this._event.setThrowable(th);
            }
        }
    }

    protected Next unhandle() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case DISPATCHED: 
                case REDISPATCHED: {
                    this._state = State.COMPLETING;
                    return Next.COMPLETE;
                }
                case IDLE: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case ASYNCSTARTED: {
                    this._initial = false;
                    this._state = State.ASYNCWAIT;
                    this.scheduleTimeout();
                    return Next.WAIT;
                }
                case REDISPATCHING: {
                    this._initial = false;
                    this._state = State.REDISPATCHED;
                    return Next.CONTINUE;
                }
                case COMPLETECALLED: {
                    this._initial = false;
                    this._state = State.COMPLETING;
                    return Next.COMPLETE;
                }
            }
            throw new IllegalStateException(this.getStatusString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(ServletContext context, String path) {
        boolean dispatch;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case ASYNCSTARTED: {
                    this._state = State.REDISPATCHING;
                    this._event.setDispatchTarget(context, path);
                    this._dispatched = true;
                    return;
                }
                case ASYNCWAIT: {
                    dispatch = !this._expired;
                    this._state = State.REDISPATCH;
                    this._event.setDispatchTarget(context, path);
                    this._dispatched = true;
                    break;
                }
                case REDISPATCH: {
                    this._event.setDispatchTarget(context, path);
                    return;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (dispatch) {
            this.cancelTimeout();
            this.scheduleDispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDispatched() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._dispatched;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expired() {
        List<AsyncListener> aListeners;
        AsyncContextEvent event;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case ASYNCWAIT: 
                case ASYNCSTARTED: {
                    this._expired = true;
                    event = this._event;
                    aListeners = this._asyncListeners;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (aListeners != null) {
            for (AsyncListener listener : aListeners) {
                try {
                    listener.onTimeout((AsyncEvent)event);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
        httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case ASYNCWAIT: 
                case ASYNCSTARTED: {
                    this._state = State.REDISPATCH;
                    break;
                }
                default: {
                    this._expired = false;
                }
            }
        }
        this.scheduleDispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        boolean handle;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case DISPATCHED: 
                case REDISPATCHED: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case IDLE: 
                case ASYNCSTARTED: {
                    this._state = State.COMPLETECALLED;
                    return;
                }
                case ASYNCWAIT: {
                    this._state = State.COMPLETECALLED;
                    handle = !this._expired;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (handle) {
            this.cancelTimeout();
            ContextHandler handler = this.getContextHandler();
            if (handler != null) {
                handler.handle(this._channel);
            } else {
                this._channel.handle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completed() {
        AsyncContextEvent event;
        List<AsyncListener> aListeners;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case COMPLETING: {
                    this._state = State.COMPLETED;
                    aListeners = this._asyncListeners;
                    event = this._event;
                    this._event = null;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (aListeners != null) {
            for (AsyncListener listener : aListeners) {
                try {
                    if (event != null && event.getThrowable() != null) {
                        event.getSuppliedRequest().setAttribute("javax.servlet.error.exception", (Object)event.getThrowable());
                        event.getSuppliedRequest().setAttribute("javax.servlet.error.message", (Object)event.getThrowable().getMessage());
                        listener.onError((AsyncEvent)event);
                        continue;
                    }
                    listener.onComplete((AsyncEvent)event);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
        if (event != null) {
            event.completed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycle() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case DISPATCHED: 
                case REDISPATCHED: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
            this._state = State.IDLE;
            this._initial = true;
            this._dispatched = false;
            this._expired = false;
            this._responseWrapped = false;
            this.cancelTimeout();
            this._timeoutMs = 30000L;
            this._event = null;
        }
    }

    protected void scheduleDispatch() {
        this._channel.execute(this._channel);
    }

    protected void scheduleTimeout() {
        Scheduler scheduler = this._channel.getScheduler();
        if (scheduler != null && this._timeoutMs > 0L) {
            this._event.setTimeoutTask(scheduler.schedule((Runnable)new AsyncTimeout(), this._timeoutMs, TimeUnit.MILLISECONDS));
        }
    }

    protected void cancelTimeout() {
        AsyncContextEvent event = this._event;
        if (event != null) {
            event.cancelTimeoutTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._expired;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitial() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._initial;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case COMPLETECALLED: 
                case ASYNCWAIT: 
                case ASYNCSTARTED: 
                case REDISPATCHING: {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCompleting() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._state == State.COMPLETING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAsync() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case COMPLETECALLED: 
                case ASYNCWAIT: 
                case REDISPATCH: 
                case REDISPATCHED: 
                case ASYNCSTARTED: 
                case REDISPATCHING: {
                    return true;
                }
            }
            return false;
        }
    }

    public Request getBaseRequest() {
        return this._channel.getRequest();
    }

    public HttpChannel<?> getHttpChannel() {
        return this._channel;
    }

    public ContextHandler getContextHandler() {
        ContextHandler.Context context;
        AsyncContextEvent event = this._event;
        if (event != null && (context = (ContextHandler.Context)event.getServletContext()) != null) {
            return context.getContextHandler();
        }
        return null;
    }

    public ServletResponse getServletResponse() {
        if (this._responseWrapped && this._event != null && this._event.getSuppliedResponse() != null) {
            return this._event.getSuppliedResponse();
        }
        return this._channel.getResponse();
    }

    public Object getAttribute(String name) {
        return this._channel.getRequest().getAttribute(name);
    }

    public void removeAttribute(String name) {
        this._channel.getRequest().removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._channel.getRequest().setAttribute(name, attribute);
    }

    public class AsyncTimeout
    implements Runnable {
        @Override
        public void run() {
            HttpChannelState.this.expired();
        }
    }

    public static enum Next {
        CONTINUE,
        WAIT,
        COMPLETE,
        RECYCLE;

    }

    public static enum State {
        IDLE,
        DISPATCHED,
        ASYNCSTARTED,
        REDISPATCHING,
        ASYNCWAIT,
        REDISPATCH,
        REDISPATCHED,
        COMPLETECALLED,
        COMPLETING,
        COMPLETED;

    }
}

