/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionContext;
import javax.servlet.http.HttpSessionEvent;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.session.AbstractSessionManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.log.Logger;

public abstract class AbstractSession
implements AbstractSessionManager.SessionIf {
    static final Logger LOG = SessionHandler.LOG;
    public static final String SESSION_KNOWN_ONLY_TO_AUTHENTICATED = "org.eclipse.jetty.security.sessionKnownOnlytoAuthenticated";
    private String _clusterId;
    private String _nodeId;
    private final AbstractSessionManager _manager;
    private final Map<String, Object> _attributes = new HashMap<String, Object>();
    private boolean _idChanged;
    private final long _created;
    private long _cookieSet;
    private long _accessed;
    private long _lastAccessed;
    private boolean _invalid;
    private boolean _doInvalidate;
    private long _maxIdleMs;
    private boolean _newSession;
    private int _requests;

    protected AbstractSession(AbstractSessionManager abstractSessionManager, HttpServletRequest request) {
        this._manager = abstractSessionManager;
        this._newSession = true;
        this._created = System.currentTimeMillis();
        this._clusterId = this._manager._sessionIdManager.newSessionId(request, this._created);
        this._nodeId = this._manager._sessionIdManager.getNodeId(this._clusterId, request);
        this._accessed = this._created;
        this._lastAccessed = this._created;
        this._requests = 1;
        long l = this._maxIdleMs = this._manager._dftMaxIdleSecs > 0 ? (long)this._manager._dftMaxIdleSecs * 1000L : -1L;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new session & id " + this._nodeId + " " + this._clusterId, new Object[0]);
        }
    }

    protected AbstractSession(AbstractSessionManager abstractSessionManager, long created, long accessed, String clusterId) {
        this._manager = abstractSessionManager;
        this._created = created;
        this._clusterId = clusterId;
        this._nodeId = this._manager._sessionIdManager.getNodeId(this._clusterId, null);
        this._accessed = accessed;
        this._lastAccessed = accessed;
        this._requests = 1;
        long l = this._maxIdleMs = this._manager._dftMaxIdleSecs > 0 ? (long)this._manager._dftMaxIdleSecs * 1000L : -1L;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new session " + this._nodeId + " " + this._clusterId, new Object[0]);
        }
    }

    protected void checkValid() throws IllegalStateException {
        if (this._invalid) {
            throw new IllegalStateException();
        }
    }

    @Override
    public AbstractSession getSession() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAccessed() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            return this._accessed;
        }
    }

    public Map<String, Object> getAttributeMap() {
        return this._attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAttribute(String name) {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            return this._attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAttributes() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            return this._attributes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<String> getAttributeNames() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            List<Object> names = this._attributes == null ? Collections.EMPTY_LIST : new ArrayList<String>(this._attributes.keySet());
            return Collections.enumeration(names);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getNames() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            return new HashSet<String>(this._attributes.keySet());
        }
    }

    public long getCookieSetTime() {
        return this._cookieSet;
    }

    @Override
    public long getCreationTime() throws IllegalStateException {
        this.checkValid();
        return this._created;
    }

    @Override
    public String getId() throws IllegalStateException {
        return this._manager._nodeIdInSessionId ? this._nodeId : this._clusterId;
    }

    public String getNodeId() {
        return this._nodeId;
    }

    public String getClusterId() {
        return this._clusterId;
    }

    @Override
    public long getLastAccessedTime() throws IllegalStateException {
        this.checkValid();
        return this._lastAccessed;
    }

    public void setLastAccessedTime(long time) {
        this._lastAccessed = time;
    }

    @Override
    public int getMaxInactiveInterval() {
        return (int)(this._maxIdleMs / 1000L);
    }

    @Override
    public ServletContext getServletContext() {
        return this._manager._context;
    }

    @Override
    @Deprecated
    public HttpSessionContext getSessionContext() throws IllegalStateException {
        this.checkValid();
        return AbstractSessionManager.__nullSessionContext;
    }

    @Override
    @Deprecated
    public Object getValue(String name) throws IllegalStateException {
        return this.getAttribute(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public String[] getValueNames() throws IllegalStateException {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            if (this._attributes == null) {
                return new String[0];
            }
            String[] a = new String[this._attributes.size()];
            return this._attributes.keySet().toArray(a);
        }
    }

    public void renewId(HttpServletRequest request) {
        this._manager._sessionIdManager.renewSessionId(this.getClusterId(), this.getNodeId(), request);
        this.setIdChanged(true);
    }

    public SessionManager getSessionManager() {
        return this._manager;
    }

    protected void setClusterId(String clusterId) {
        this._clusterId = clusterId;
    }

    protected void setNodeId(String nodeId) {
        this._nodeId = nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean access(long time) {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            if (this._invalid) {
                return false;
            }
            this._newSession = false;
            this._lastAccessed = this._accessed;
            this._accessed = time;
            if (this._maxIdleMs > 0L && this._lastAccessed > 0L && this._lastAccessed + this._maxIdleMs < time) {
                this.invalidate();
                return false;
            }
            ++this._requests;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void complete() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            --this._requests;
            if (this._doInvalidate && this._requests <= 0) {
                this.doInvalidate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void timeout() throws IllegalStateException {
        this._manager.removeSession(this, true);
        boolean do_invalidate = false;
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            if (!this._invalid) {
                if (this._requests <= 0) {
                    do_invalidate = true;
                } else {
                    this._doInvalidate = true;
                }
            }
        }
        if (do_invalidate) {
            this.doInvalidate();
        }
    }

    @Override
    public void invalidate() throws IllegalStateException {
        this.checkValid();
        this._manager.removeSession(this, true);
        this.doInvalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvalidate() throws IllegalStateException {
        try {
            LOG.debug("invalidate {}", this._clusterId);
            if (this.isValid()) {
                this.clearAttributes();
            }
        }
        finally {
            AbstractSession abstractSession = this;
            synchronized (abstractSession) {
                this._invalid = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAttributes() {
        while (this._attributes != null && this._attributes.size() > 0) {
            ArrayList<String> keys;
            AbstractSession abstractSession = this;
            synchronized (abstractSession) {
                keys = new ArrayList<String>(this._attributes.keySet());
            }
            for (String key : keys) {
                Object value;
                AbstractSession abstractSession2 = this;
                synchronized (abstractSession2) {
                    value = this.doPutOrRemove(key, null);
                }
                this.unbindValue(key, value);
                this._manager.doSessionAttributeListeners(this, key, value, null);
            }
        }
        if (this._attributes != null) {
            this._attributes.clear();
        }
    }

    public boolean isIdChanged() {
        return this._idChanged;
    }

    @Override
    public boolean isNew() throws IllegalStateException {
        this.checkValid();
        return this._newSession;
    }

    @Override
    @Deprecated
    public void putValue(String name, Object value) throws IllegalStateException {
        this.setAttribute(name, value);
    }

    @Override
    public void removeAttribute(String name) {
        this.setAttribute(name, null);
    }

    @Override
    @Deprecated
    public void removeValue(String name) throws IllegalStateException {
        this.removeAttribute(name);
    }

    protected Object doPutOrRemove(String name, Object value) {
        return value == null ? this._attributes.remove(name) : this._attributes.put(name, value);
    }

    protected Object doGet(String name) {
        return this._attributes.get(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.updateAttribute(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean updateAttribute(String name, Object value) {
        Object old = null;
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this.checkValid();
            old = this.doPutOrRemove(name, value);
        }
        if (value == null || !value.equals(old)) {
            if (old != null) {
                this.unbindValue(name, old);
            }
            if (value != null) {
                this.bindValue(name, value);
            }
            this._manager.doSessionAttributeListeners(this, name, old, value);
            return true;
        }
        return false;
    }

    protected void addAttributes(Map<String, Object> map) {
        this._attributes.putAll(map);
    }

    public void setIdChanged(boolean changed) {
        this._idChanged = changed;
    }

    @Override
    public void setMaxInactiveInterval(int secs) {
        this._maxIdleMs = (long)secs * 1000L;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.getId() + "@" + this.hashCode();
    }

    public void bindValue(String name, Object value) {
        if (value != null && value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent(this, name));
        }
    }

    public boolean isValid() {
        return !this._invalid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cookieSet() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this._cookieSet = this._accessed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRequests() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            return this._requests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequests(int requests) {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            this._requests = requests;
        }
    }

    public void unbindValue(String name, Object value) {
        if (value != null && value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent(this, name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void willPassivate() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            HttpSessionEvent event = new HttpSessionEvent(this);
            for (Object value : this._attributes.values()) {
                if (!(value instanceof HttpSessionActivationListener)) continue;
                HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                listener.sessionWillPassivate(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void didActivate() {
        AbstractSession abstractSession = this;
        synchronized (abstractSession) {
            HttpSessionEvent event = new HttpSessionEvent(this);
            for (Object value : this._attributes.values()) {
                if (!(value instanceof HttpSessionActivationListener)) continue;
                HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
                listener.sessionDidActivate(event);
            }
        }
    }
}

