/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.maven.plugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.jetty.maven.plugin.MavenWebAppContext;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.xml.XmlConfiguration;

public class WebAppPropertyConverter {
    public static String WEB_XML = "web.xml";
    public static String QUICKSTART_WEB_XML = "quickstart.web.xml";
    public static String CONTEXT_XML = "context.xml";
    public static String CONTEXT_PATH = "context.path";
    public static String TMP_DIR = "tmp.dir";
    public static String TMP_DIR_PERSIST = "tmp.dir.persist";
    public static String BASE_DIRS = "base.dirs";
    public static String WAR_FILE = "war.file";
    public static String CLASSES_DIR = "classes.dir";
    public static String TEST_CLASSES_DIR = "testClasses.dir";
    public static String LIB_JARS = "lib.jars";
    public static String DEFAULTS_DESCRIPTOR = "web.default.xml";
    public static String OVERRIDE_DESCRIPTORS = "web.overrides.xml";

    public static void toProperties(MavenWebAppContext webApp, File propsFile, String contextXml) throws Exception {
        Object tmp;
        if (webApp == null) {
            throw new IllegalArgumentException("No webapp");
        }
        if (propsFile == null) {
            throw new IllegalArgumentException("No properties file");
        }
        if (propsFile.exists()) {
            propsFile.delete();
        }
        propsFile.createNewFile();
        Properties props = new Properties();
        if (webApp.getDescriptor() != null) {
            props.put(WEB_XML, webApp.getDescriptor());
        }
        if ((tmp = webApp.getAttribute("org.eclipse.jetty.quickstart.xml")) != null) {
            props.put(QUICKSTART_WEB_XML, tmp.toString());
        }
        if (webApp.getContextPath() != null) {
            props.put(CONTEXT_PATH, webApp.getContextPath());
        }
        props.put(TMP_DIR, webApp.getTempDirectory().getAbsolutePath());
        props.put(TMP_DIR_PERSIST, Boolean.toString(webApp.isPersistTempDirectory()));
        Resource baseResource = webApp.getBaseResource();
        if (baseResource instanceof ResourceCollection) {
            props.put(BASE_DIRS, WebAppPropertyConverter.toCSV(((ResourceCollection)webApp.getBaseResource()).getResources()));
        } else if (baseResource instanceof Resource) {
            props.put(BASE_DIRS, webApp.getBaseResource().toString());
        }
        if (webApp.getWar() != null) {
            props.put(WAR_FILE, webApp.getWar());
        }
        if (webApp.getClasses() != null) {
            props.put(CLASSES_DIR, webApp.getClasses().getAbsolutePath());
        }
        if (webApp.getTestClasses() != null) {
            props.put(TEST_CLASSES_DIR, webApp.getTestClasses().getAbsolutePath());
        }
        List<File> deps = webApp.getWebInfLib();
        StringBuilder strbuff = new StringBuilder();
        if (deps != null) {
            for (int i = 0; i < deps.size(); ++i) {
                File d = deps.get(i);
                strbuff.append(d.getAbsolutePath());
                if (i >= deps.size() - 1) continue;
                strbuff.append(",");
            }
        }
        props.put(LIB_JARS, strbuff.toString());
        if (contextXml != null) {
            props.put(CONTEXT_XML, contextXml);
        }
        if (webApp.getDefaultsDescriptor() != null) {
            props.put(DEFAULTS_DESCRIPTOR, webApp.getDefaultsDescriptor());
        }
        if (webApp.getOverrideDescriptors() != null) {
            props.put(OVERRIDE_DESCRIPTORS, String.join((CharSequence)",", webApp.getOverrideDescriptors()));
        }
        try (BufferedWriter out = Files.newBufferedWriter(propsFile.toPath(), new OpenOption[0]);){
            props.store(out, "properties for webapp");
        }
    }

    public static void fromProperties(MavenWebAppContext webApp, String resource, Server server, Map<String, String> jettyProperties) throws Exception {
        if (resource == null) {
            throw new IllegalStateException("No resource");
        }
        WebAppPropertyConverter.fromProperties(webApp, Resource.newResource((String)resource).getFile(), server, jettyProperties);
    }

    public static void fromProperties(MavenWebAppContext webApp, Properties webAppProperties, Server server, Map<String, String> jettyProperties) throws Exception {
        if (webApp == null) {
            throw new IllegalArgumentException("No webapp");
        }
        if (webAppProperties == null) {
            return;
        }
        String str = webAppProperties.getProperty(CONTEXT_PATH);
        if (!StringUtil.isBlank((String)str)) {
            webApp.setContextPath(str);
        }
        if (!StringUtil.isBlank((String)(str = webAppProperties.getProperty(WEB_XML)))) {
            webApp.setDescriptor(str);
        }
        if (!StringUtil.isBlank((String)(str = webAppProperties.getProperty(QUICKSTART_WEB_XML)))) {
            webApp.setAttribute("org.eclipse.jetty.quickstart.xml", Resource.newResource((String)str));
        }
        if (!StringUtil.isBlank((String)(str = webAppProperties.getProperty(TMP_DIR)))) {
            webApp.setTempDirectory(new File(str.trim()));
        }
        if (!StringUtil.isBlank((String)(str = webAppProperties.getProperty(TMP_DIR_PERSIST)))) {
            webApp.setPersistTempDirectory(Boolean.valueOf(str));
        }
        if (!StringUtil.isBlank((String)(str = webAppProperties.getProperty(BASE_DIRS)))) {
            ResourceCollection bases = new ResourceCollection(StringUtil.csvSplit((String)str));
            webApp.setWar(null);
            webApp.setBaseResource((Resource)bases);
        }
        if (!StringUtil.isBlank((String)(str = webAppProperties.getProperty(WAR_FILE)))) {
            webApp.setWar(str);
        }
        if (!StringUtil.isBlank((String)(str = webAppProperties.getProperty(CLASSES_DIR)))) {
            webApp.setClasses(new File(str));
        }
        if (!StringUtil.isBlank((String)(str = webAppProperties.getProperty(TEST_CLASSES_DIR)))) {
            webApp.setTestClasses(new File(str));
        }
        if (!StringUtil.isBlank((String)(str = webAppProperties.getProperty(LIB_JARS)))) {
            ArrayList<File> jars = new ArrayList<File>();
            String[] names = StringUtil.csvSplit((String)str);
            for (int j = 0; names != null && j < names.length; ++j) {
                jars.add(new File(names[j].trim()));
            }
            webApp.setWebInfLib(jars);
        }
        if (!StringUtil.isBlank((String)(str = webAppProperties.getProperty(DEFAULTS_DESCRIPTOR)))) {
            webApp.setDefaultsDescriptor(str);
        }
        if (!StringUtil.isBlank((String)(str = webAppProperties.getProperty(OVERRIDE_DESCRIPTORS)))) {
            String[] names = StringUtil.csvSplit((String)str);
            for (int j = 0; names != null && j < names.length; ++j) {
                webApp.addOverrideDescriptor(names[j]);
            }
        }
        if (!StringUtil.isBlank((String)(str = webAppProperties.getProperty(CONTEXT_XML)))) {
            XmlConfiguration xmlConfiguration = new XmlConfiguration(Resource.newResource((String)str));
            xmlConfiguration.getIdMap().put("Server", server);
            if (jettyProperties != null) {
                for (Map.Entry<String, String> prop : jettyProperties.entrySet()) {
                    xmlConfiguration.getProperties().put(prop.getKey(), prop.getValue());
                }
            }
            xmlConfiguration.configure((Object)webApp);
        }
    }

    public static void fromProperties(MavenWebAppContext webApp, File propsFile, Server server, Map<String, String> jettyProperties) throws Exception {
        if (propsFile == null) {
            throw new IllegalArgumentException("No properties file");
        }
        if (!propsFile.exists()) {
            throw new IllegalArgumentException(propsFile.getCanonicalPath() + " does not exist");
        }
        Properties props = new Properties();
        try (FileInputStream in = new FileInputStream(propsFile);){
            props.load(in);
        }
        WebAppPropertyConverter.fromProperties(webApp, props, server, jettyProperties);
    }

    private static String toCSV(List<Resource> resources) {
        return resources.stream().map(Object::toString).collect(Collectors.joining(","));
    }
}

