/*******************************************************************************
 * Copyright (c) 2013 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.engine.emitter.pptx.writer;

import java.io.IOException;

import org.eclipse.birt.report.engine.ooxml.constants.ContentTypes;
import org.eclipse.birt.report.engine.ooxml.constants.NameSpaces;
import org.eclipse.birt.report.engine.ooxml.constants.RelationshipTypes;


public class SlideLayout extends Component
{
	private int index;

	public SlideLayout( Slide slide, int slideIndex ) throws IOException
	{
		this.index = slideIndex;
		String uri = "../slideLayouts/slideLayout" + index + ".xml";
		String type = ContentTypes.SLIDE_LAYOUT;
		String relationshipType = RelationshipTypes.SLIDE_LAYOUT;
		super.initialize( slide.getPart( ), uri, type, relationshipType, false );
		SlideMaster slideMaster = slide.getPresentation( ).getSlideMaster( );
		referTo( slideMaster );
		slideMaster.addSlideLayout( this );
		initialize( );
	}

	private void initialize( )
	{
		writer.startWriter( );
		writer.openTag( "p:sldLayout" );
		writer.nameSpace( "a", NameSpaces.DRAWINGML );
		writer.nameSpace( "r", NameSpaces.RELATIONSHIPS );
		writer.nameSpace( "p", NameSpaces.PRESENTATIONML );
		writer.attribute( "type", "title" );
		writer.attribute( "preserve", "1" );
		writer.openTag( "p:cSld" );
		writer.attribute( "name", "Title Slide" );
		writer.openTag( "p:spTree" );
		writer.openTag( "p:nvGrpSpPr" );
		writer.openTag( "p:cNvPr" );
		writer.attribute( "id", "1" );
		writer.attribute( "name", "" );
		writer.closeTag( "p:cNvPr" );
		writer.openTag( "p:cNvGrpSpPr" );
		writer.closeTag( "p:cNvGrpSpPr" );
		writer.openTag( "p:nvPr" );
		writer.closeTag( "p:nvPr" );
		writer.closeTag( "p:nvGrpSpPr" );
		writer.openTag( "p:grpSpPr" );
		writer.openTag( "a:xfrm" );
		writer.openTag( "a:off" );
		writer.attribute( "x", "0" );
		writer.attribute( "y", "0" );
		writer.closeTag( "a:off" );
		writer.openTag( "a:ext" );
		writer.attribute( "cx", "0" );
		writer.attribute( "cy", "0" );
		writer.closeTag( "a:ext" );
		writer.openTag( "a:chOff" );
		writer.attribute( "x", "0" );
		writer.attribute( "y", "0" );
		writer.closeTag( "a:chOff" );
		writer.openTag( "a:chExt" );
		writer.attribute( "cx", "0" );
		writer.attribute( "cy", "0" );
		writer.closeTag( "a:chExt" );
		writer.closeTag( "a:xfrm" );
		writer.closeTag( "p:grpSpPr" );
		writer.openTag( "p:sp" );
		writer.openTag( "p:nvSpPr" );
		writer.openTag( "p:cNvPr" );
		writer.attribute( "id", "2" );
		writer.attribute( "name", "Title 1" );
		writer.closeTag( "p:cNvPr" );
		writer.openTag( "p:cNvSpPr" );
		writer.openTag( "a:spLocks" );
		writer.attribute( "noGrp", "1" );
		writer.closeTag( "a:spLocks" );
		writer.closeTag( "p:cNvSpPr" );
		writer.openTag( "p:nvPr" );
		writer.openTag( "p:ph" );
		writer.attribute( "type", "ctrTitle" );
		writer.closeTag( "p:ph" );
		writer.closeTag( "p:nvPr" );
		writer.closeTag( "p:nvSpPr" );
		writer.openTag( "p:spPr" );
		writer.openTag( "a:xfrm" );
		writer.openTag( "a:off" );
		writer.attribute( "x", "685800" );
		writer.attribute( "y", "2130425" );
		writer.closeTag( "a:off" );
		writer.openTag( "a:ext" );
		writer.attribute( "cx", "7772400" );
		writer.attribute( "cy", "1470025" );
		writer.closeTag( "a:ext" );
		writer.closeTag( "a:xfrm" );
		writer.closeTag( "p:spPr" );
		writer.openTag( "p:txBody" );
		writer.openTag( "a:bodyPr" );
		writer.closeTag( "a:bodyPr" );
		writer.openTag( "a:lstStyle" );
		writer.closeTag( "a:lstStyle" );
		writer.openTag( "a:p" );
		writer.openTag( "a:r" );
		writer.openTag( "a:rPr" );
		writer.attribute( "lang", "en-US" );
		writer.attribute( "altLang", "zh-CN" );
		writer.attribute( "smtClean", "0" );
		writer.closeTag( "a:rPr" );
		writer.openTag( "a:t" );
		writer.closeTag( "a:t" );
		writer.closeTag( "a:r" );
		writer.openTag( "a:endParaRPr" );
		writer.attribute( "lang", "zh-CN" );
		writer.attribute( "altLang", "en-US" );
		writer.closeTag( "a:endParaRPr" );
		writer.closeTag( "a:p" );
		writer.closeTag( "p:txBody" );
		writer.closeTag( "p:sp" );
		writer.openTag( "p:sp" );
		writer.openTag( "p:nvSpPr" );
		writer.openTag( "p:cNvPr" );
		writer.attribute( "id", "3" );
		writer.attribute( "name", "Subtitle 2" );
		writer.closeTag( "p:cNvPr" );
		writer.openTag( "p:cNvSpPr" );
		writer.openTag( "a:spLocks" );
		writer.attribute( "noGrp", "1" );
		writer.closeTag( "a:spLocks" );
		writer.closeTag( "p:cNvSpPr" );
		writer.openTag( "p:nvPr" );
		writer.openTag( "p:ph" );
		writer.attribute( "type", "subTitle" );
		writer.attribute( "idx", "1" );
		writer.closeTag( "p:ph" );
		writer.closeTag( "p:nvPr" );
		writer.closeTag( "p:nvSpPr" );
		writer.openTag( "p:spPr" );
		writer.openTag( "a:xfrm" );
		writer.openTag( "a:off" );
		writer.attribute( "x", "1371600" );
		writer.attribute( "y", "3886200" );
		writer.closeTag( "a:off" );
		writer.openTag( "a:ext" );
		writer.attribute( "cx", "6400800" );
		writer.attribute( "cy", "1752600" );
		writer.closeTag( "a:ext" );
		writer.closeTag( "a:xfrm" );
		writer.closeTag( "p:spPr" );
		writer.openTag( "p:txBody" );
		writer.openTag( "a:bodyPr" );
		writer.closeTag( "a:bodyPr" );
		writer.openTag( "a:lstStyle" );
		writer.openTag( "a:lvl1pPr" );
		writer.attribute( "marL", "0" );
		writer.attribute( "indent", "0" );
		writer.attribute( "algn", "ctr" );
		writer.openTag( "a:buNone" );
		writer.closeTag( "a:buNone" );
		writer.openTag( "a:defRPr" );
		writer.openTag( "a:solidFill" );
		writer.openTag( "a:schemeClr" );
		writer.attribute( "val", "tx1" );
		writer.openTag( "a:tint" );
		writer.attribute( "val", "75000" );
		writer.closeTag( "a:tint" );
		writer.closeTag( "a:schemeClr" );
		writer.closeTag( "a:solidFill" );
		writer.closeTag( "a:defRPr" );
		writer.closeTag( "a:lvl1pPr" );
		writer.openTag( "a:lvl2pPr" );
		writer.attribute( "marL", "457200" );
		writer.attribute( "indent", "0" );
		writer.attribute( "algn", "ctr" );
		writer.openTag( "a:buNone" );
		writer.closeTag( "a:buNone" );
		writer.openTag( "a:defRPr" );
		writer.openTag( "a:solidFill" );
		writer.openTag( "a:schemeClr" );
		writer.attribute( "val", "tx1" );
		writer.openTag( "a:tint" );
		writer.attribute( "val", "75000" );
		writer.closeTag( "a:tint" );
		writer.closeTag( "a:schemeClr" );
		writer.closeTag( "a:solidFill" );
		writer.closeTag( "a:defRPr" );
		writer.closeTag( "a:lvl2pPr" );
		writer.openTag( "a:lvl3pPr" );
		writer.attribute( "marL", "914400" );
		writer.attribute( "indent", "0" );
		writer.attribute( "algn", "ctr" );
		writer.openTag( "a:buNone" );
		writer.closeTag( "a:buNone" );
		writer.openTag( "a:defRPr" );
		writer.openTag( "a:solidFill" );
		writer.openTag( "a:schemeClr" );
		writer.attribute( "val", "tx1" );
		writer.openTag( "a:tint" );
		writer.attribute( "val", "75000" );
		writer.closeTag( "a:tint" );
		writer.closeTag( "a:schemeClr" );
		writer.closeTag( "a:solidFill" );
		writer.closeTag( "a:defRPr" );
		writer.closeTag( "a:lvl3pPr" );
		writer.openTag( "a:lvl4pPr" );
		writer.attribute( "marL", "1371600" );
		writer.attribute( "indent", "0" );
		writer.attribute( "algn", "ctr" );
		writer.openTag( "a:buNone" );
		writer.closeTag( "a:buNone" );
		writer.openTag( "a:defRPr" );
		writer.openTag( "a:solidFill" );
		writer.openTag( "a:schemeClr" );
		writer.attribute( "val", "tx1" );
		writer.openTag( "a:tint" );
		writer.attribute( "val", "75000" );
		writer.closeTag( "a:tint" );
		writer.closeTag( "a:schemeClr" );
		writer.closeTag( "a:solidFill" );
		writer.closeTag( "a:defRPr" );
		writer.closeTag( "a:lvl4pPr" );
		writer.openTag( "a:lvl5pPr" );
		writer.attribute( "marL", "1828800" );
		writer.attribute( "indent", "0" );
		writer.attribute( "algn", "ctr" );
		writer.openTag( "a:buNone" );
		writer.closeTag( "a:buNone" );
		writer.openTag( "a:defRPr" );
		writer.openTag( "a:solidFill" );
		writer.openTag( "a:schemeClr" );
		writer.attribute( "val", "tx1" );
		writer.openTag( "a:tint" );
		writer.attribute( "val", "75000" );
		writer.closeTag( "a:tint" );
		writer.closeTag( "a:schemeClr" );
		writer.closeTag( "a:solidFill" );
		writer.closeTag( "a:defRPr" );
		writer.closeTag( "a:lvl5pPr" );
		writer.openTag( "a:lvl6pPr" );
		writer.attribute( "marL", "2286000" );
		writer.attribute( "indent", "0" );
		writer.attribute( "algn", "ctr" );
		writer.openTag( "a:buNone" );
		writer.closeTag( "a:buNone" );
		writer.openTag( "a:defRPr" );
		writer.openTag( "a:solidFill" );
		writer.openTag( "a:schemeClr" );
		writer.attribute( "val", "tx1" );
		writer.openTag( "a:tint" );
		writer.attribute( "val", "75000" );
		writer.closeTag( "a:tint" );
		writer.closeTag( "a:schemeClr" );
		writer.closeTag( "a:solidFill" );
		writer.closeTag( "a:defRPr" );
		writer.closeTag( "a:lvl6pPr" );
		writer.openTag( "a:lvl7pPr" );
		writer.attribute( "marL", "2743200" );
		writer.attribute( "indent", "0" );
		writer.attribute( "algn", "ctr" );
		writer.openTag( "a:buNone" );
		writer.closeTag( "a:buNone" );
		writer.openTag( "a:defRPr" );
		writer.openTag( "a:solidFill" );
		writer.openTag( "a:schemeClr" );
		writer.attribute( "val", "tx1" );
		writer.openTag( "a:tint" );
		writer.attribute( "val", "75000" );
		writer.closeTag( "a:tint" );
		writer.closeTag( "a:schemeClr" );
		writer.closeTag( "a:solidFill" );
		writer.closeTag( "a:defRPr" );
		writer.closeTag( "a:lvl7pPr" );
		writer.openTag( "a:lvl8pPr" );
		writer.attribute( "marL", "3200400" );
		writer.attribute( "indent", "0" );
		writer.attribute( "algn", "ctr" );
		writer.openTag( "a:buNone" );
		writer.closeTag( "a:buNone" );
		writer.openTag( "a:defRPr" );
		writer.openTag( "a:solidFill" );
		writer.openTag( "a:schemeClr" );
		writer.attribute( "val", "tx1" );
		writer.openTag( "a:tint" );
		writer.attribute( "val", "75000" );
		writer.closeTag( "a:tint" );
		writer.closeTag( "a:schemeClr" );
		writer.closeTag( "a:solidFill" );
		writer.closeTag( "a:defRPr" );
		writer.closeTag( "a:lvl8pPr" );
		writer.openTag( "a:lvl9pPr" );
		writer.attribute( "marL", "3657600" );
		writer.attribute( "indent", "0" );
		writer.attribute( "algn", "ctr" );
		writer.openTag( "a:buNone" );
		writer.closeTag( "a:buNone" );
		writer.openTag( "a:defRPr" );
		writer.openTag( "a:solidFill" );
		writer.openTag( "a:schemeClr" );
		writer.attribute( "val", "tx1" );
		writer.openTag( "a:tint" );
		writer.attribute( "val", "75000" );
		writer.closeTag( "a:tint" );
		writer.closeTag( "a:schemeClr" );
		writer.closeTag( "a:solidFill" );
		writer.closeTag( "a:defRPr" );
		writer.closeTag( "a:lvl9pPr" );
		writer.closeTag( "a:lstStyle" );
		writer.openTag( "a:p" );
		writer.openTag( "a:r" );
		writer.openTag( "a:rPr" );
		writer.attribute( "lang", "en-US" );
		writer.attribute( "altLang", "zh-CN" );
		writer.attribute( "smtClean", "0" );
		writer.closeTag( "a:rPr" );
		writer.openTag( "a:t" );
		writer.closeTag( "a:t" );
		writer.closeTag( "a:r" );
		writer.openTag( "a:endParaRPr" );
		writer.attribute( "lang", "zh-CN" );
		writer.attribute( "altLang", "en-US" );
		writer.closeTag( "a:endParaRPr" );
		writer.closeTag( "a:p" );
		writer.closeTag( "p:txBody" );
		writer.closeTag( "p:sp" );
		writer.openTag( "p:sp" );
		writer.openTag( "p:nvSpPr" );
		writer.openTag( "p:cNvPr" );
		writer.attribute( "id", "4" );
		writer.attribute( "name", "Date Placeholder 3" );
		writer.closeTag( "p:cNvPr" );
		writer.openTag( "p:cNvSpPr" );
		writer.openTag( "a:spLocks" );
		writer.attribute( "noGrp", "1" );
		writer.closeTag( "a:spLocks" );
		writer.closeTag( "p:cNvSpPr" );
		writer.openTag( "p:nvPr" );
		writer.openTag( "p:ph" );
		writer.attribute( "type", "dt" );
		writer.attribute( "sz", "half" );
		writer.attribute( "idx", "10" );
		writer.closeTag( "p:ph" );
		writer.closeTag( "p:nvPr" );
		writer.closeTag( "p:nvSpPr" );
		writer.openTag( "p:spPr" );
		writer.closeTag( "p:spPr" );
		writer.openTag( "p:txBody" );
		writer.openTag( "a:bodyPr" );
		writer.closeTag( "a:bodyPr" );
		writer.openTag( "a:lstStyle" );
		writer.closeTag( "a:lstStyle" );
		writer.openTag( "a:p" );
		writer.openTag( "a:fld" );
		writer.attribute( "id", "{49C2E7E4-DA10-44DC-AD7A-F0CA93F417A5}" );
		writer.attribute( "type", "datetimeFigureOut" );
		writer.openTag( "a:rPr" );
		writer.attribute( "lang", "zh-CN" );
		writer.attribute( "altLang", "en-US" );
		writer.attribute( "smtClean", "0" );
		writer.closeTag( "a:rPr" );
		writer.openTag( "a:t" );
		writer.closeTag( "a:t" );
		writer.closeTag( "a:fld" );
		writer.openTag( "a:endParaRPr" );
		writer.attribute( "lang", "zh-CN" );
		writer.attribute( "altLang", "en-US" );
		writer.closeTag( "a:endParaRPr" );
		writer.closeTag( "a:p" );
		writer.closeTag( "p:txBody" );
		writer.closeTag( "p:sp" );
		writer.openTag( "p:sp" );
		writer.openTag( "p:nvSpPr" );
		writer.openTag( "p:cNvPr" );
		writer.attribute( "id", "5" );
		writer.attribute( "name", "Footer Placeholder 4" );
		writer.closeTag( "p:cNvPr" );
		writer.openTag( "p:cNvSpPr" );
		writer.openTag( "a:spLocks" );
		writer.attribute( "noGrp", "1" );
		writer.closeTag( "a:spLocks" );
		writer.closeTag( "p:cNvSpPr" );
		writer.openTag( "p:nvPr" );
		writer.openTag( "p:ph" );
		writer.attribute( "type", "ftr" );
		writer.attribute( "sz", "quarter" );
		writer.attribute( "idx", "11" );
		writer.closeTag( "p:ph" );
		writer.closeTag( "p:nvPr" );
		writer.closeTag( "p:nvSpPr" );
		writer.openTag( "p:spPr" );
		writer.closeTag( "p:spPr" );
		writer.openTag( "p:txBody" );
		writer.openTag( "a:bodyPr" );
		writer.closeTag( "a:bodyPr" );
		writer.openTag( "a:lstStyle" );
		writer.closeTag( "a:lstStyle" );
		writer.openTag( "a:p" );
		writer.openTag( "a:endParaRPr" );
		writer.attribute( "lang", "zh-CN" );
		writer.attribute( "altLang", "en-US" );
		writer.closeTag( "a:endParaRPr" );
		writer.closeTag( "a:p" );
		writer.closeTag( "p:txBody" );
		writer.closeTag( "p:sp" );
		writer.openTag( "p:sp" );
		writer.openTag( "p:nvSpPr" );
		writer.openTag( "p:cNvPr" );
		writer.attribute( "id", "6" );
		writer.attribute( "name", "Slide Number Placeholder 5" );
		writer.closeTag( "p:cNvPr" );
		writer.openTag( "p:cNvSpPr" );
		writer.openTag( "a:spLocks" );
		writer.attribute( "noGrp", "1" );
		writer.closeTag( "a:spLocks" );
		writer.closeTag( "p:cNvSpPr" );
		writer.openTag( "p:nvPr" );
		writer.openTag( "p:ph" );
		writer.attribute( "type", "sldNum" );
		writer.attribute( "sz", "quarter" );
		writer.attribute( "idx", "12" );
		writer.closeTag( "p:ph" );
		writer.closeTag( "p:nvPr" );
		writer.closeTag( "p:nvSpPr" );
		writer.openTag( "p:spPr" );
		writer.closeTag( "p:spPr" );
		writer.openTag( "p:txBody" );
		writer.openTag( "a:bodyPr" );
		writer.closeTag( "a:bodyPr" );
		writer.openTag( "a:lstStyle" );
		writer.closeTag( "a:lstStyle" );
		writer.openTag( "a:p" );
		writer.openTag( "a:fld" );
		writer.attribute( "id", "{A0E4456A-989D-4A99-BC63-762ABE8E2A9B}" );
		writer.attribute( "type", "slidenum" );
		writer.openTag( "a:rPr" );
		writer.attribute( "lang", "zh-CN" );
		writer.attribute( "altLang", "en-US" );
		writer.attribute( "smtClean", "0" );
		writer.closeTag( "a:rPr" );
		writer.openTag( "a:t" );
		writer.closeTag( "a:t" );
		writer.closeTag( "a:fld" );
		writer.openTag( "a:endParaRPr" );
		writer.attribute( "lang", "zh-CN" );
		writer.attribute( "altLang", "en-US" );
		writer.closeTag( "a:endParaRPr" );
		writer.closeTag( "a:p" );
		writer.closeTag( "p:txBody" );
		writer.closeTag( "p:sp" );
		writer.closeTag( "p:spTree" );
		writer.closeTag( "p:cSld" );
		writer.openTag( "p:clrMapOvr" );
		writer.openTag( "a:masterClrMapping" );
		writer.closeTag( "a:masterClrMapping" );
		writer.closeTag( "p:clrMapOvr" );
		writer.closeTag( "p:sldLayout" );
		writer.endWriter( );
		writer.close( );
		this.writer = null;
	}
}
