/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.style;

import java.awt.Color;
import org.eclipse.birt.report.engine.nLayout.area.style.AreaConstants;
import org.eclipse.birt.report.engine.nLayout.area.style.BackgroundImageInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.BorderInfo;

public class BoxStyle
extends AreaConstants {
    public static final BoxStyle DEFAULT = new ImmutableBoxStyle();
    protected Color backgroundColor = null;
    protected BackgroundImageInfo backgroundImage = null;
    protected BorderInfo topBorder = null;
    protected BorderInfo leftBorder = null;
    protected BorderInfo rightBorder = null;
    protected BorderInfo bottomBorder = null;

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public BoxStyle() {
    }

    public BoxStyle(BoxStyle bs) {
        this.backgroundColor = bs.backgroundColor;
        if (bs.topBorder != null) {
            this.topBorder = new BorderInfo(bs.topBorder);
        }
        if (bs.leftBorder != null) {
            this.leftBorder = new BorderInfo(bs.leftBorder);
        }
        if (bs.rightBorder != null) {
            this.rightBorder = new BorderInfo(bs.rightBorder);
        }
        if (bs.bottomBorder != null) {
            this.bottomBorder = new BorderInfo(bs.bottomBorder);
        }
        if (bs.backgroundImage != null) {
            this.backgroundImage = new BackgroundImageInfo(bs.backgroundImage);
        }
    }

    public void clearBorder() {
        this.topBorder = null;
        this.leftBorder = null;
        this.rightBorder = null;
        this.bottomBorder = null;
    }

    public BackgroundImageInfo getBackgroundImage() {
        return this.backgroundImage;
    }

    public BorderInfo getTopBorder() {
        return this.topBorder;
    }

    public BorderInfo getLeftBorder() {
        return this.leftBorder;
    }

    public BorderInfo getRightBorder() {
        return this.rightBorder;
    }

    public BorderInfo getBottomBorder() {
        return this.bottomBorder;
    }

    public int getLeftBorderWidth() {
        if (this.leftBorder != null) {
            return this.leftBorder.getWidth();
        }
        return 0;
    }

    public int getRightBorderWidth() {
        if (this.rightBorder != null) {
            return this.rightBorder.getWidth();
        }
        return 0;
    }

    public int getTopBorderWidth() {
        if (this.topBorder != null) {
            return this.topBorder.getWidth();
        }
        return 0;
    }

    public int getBottomBorderWidth() {
        if (this.bottomBorder != null) {
            return this.bottomBorder.getWidth();
        }
        return 0;
    }

    public Color getLeftBorderColor() {
        if (this.leftBorder != null) {
            return this.leftBorder.getColor();
        }
        return null;
    }

    public Color getRightBorderColor() {
        if (this.rightBorder != null) {
            return this.rightBorder.getColor();
        }
        return null;
    }

    public Color getTopBorderColor() {
        if (this.topBorder != null) {
            return this.topBorder.getColor();
        }
        return null;
    }

    public Color getBottomBorderColor() {
        if (this.bottomBorder != null) {
            return this.bottomBorder.getColor();
        }
        return null;
    }

    public int getLeftBorderStyle() {
        if (this.leftBorder != null) {
            return this.leftBorder.getStyle();
        }
        return 0;
    }

    public int getRightBorderStyle() {
        if (this.rightBorder != null) {
            return this.rightBorder.getStyle();
        }
        return 0;
    }

    public int getTopBorderStyle() {
        if (this.topBorder != null) {
            return this.topBorder.getStyle();
        }
        return 0;
    }

    public int getBottomBorderStyle() {
        if (this.bottomBorder != null) {
            return this.bottomBorder.getStyle();
        }
        return 0;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setBackgroundImage(BackgroundImageInfo backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public void setTopBorder(BorderInfo topBorder) {
        this.topBorder = topBorder;
    }

    public void setLeftBorder(BorderInfo leftBorder) {
        this.leftBorder = leftBorder;
    }

    public void setRightBorder(BorderInfo rightBorder) {
        this.rightBorder = rightBorder;
    }

    public void setBottomBorder(BorderInfo bottomBorder) {
        this.bottomBorder = bottomBorder;
    }

    private static class ImmutableBoxStyle
    extends BoxStyle {
        private ImmutableBoxStyle() {
        }

        public void setBackgroundColor(Color backgroundColor) {
            throw new UnsupportedOperationException();
        }

        public void setBottomBorder(BorderInfo bottomBorder) {
            throw new UnsupportedOperationException();
        }

        public void setBackgroundImage(BackgroundImageInfo backgroundImage) {
            throw new UnsupportedOperationException();
        }

        public void setLeftBorder(BorderInfo leftBorder) {
            throw new UnsupportedOperationException();
        }

        public void setRightBorder(BorderInfo rightBorder) {
            throw new UnsupportedOperationException();
        }

        public void setTopBorder(BorderInfo topBorder) {
            throw new UnsupportedOperationException();
        }
    }
}

