/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.layout.pdf.font.FontHandler;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.ILayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockTextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.InlineStackingArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.LineArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TemplateArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextAreaLayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextLineArea;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;

public class TemplateAreaLayout
implements ILayout {
    protected IContent content;
    protected LayoutContext context;
    protected ContainerArea parent;

    public TemplateAreaLayout(ContainerArea parent, LayoutContext context, IContent content) {
        this.content = content;
        this.parent = parent;
        this.context = context;
    }

    public void layout() throws BirtException {
        boolean isInline = this.parent instanceof InlineStackingArea;
        if (isInline) {
            if (this.parent instanceof LineArea) {
                InlineContainerArea inlineContainer = new InlineContainerArea(this.parent, this.context, this.content);
                inlineContainer.initialize();
                this.addTemplateArea(inlineContainer, true);
                inlineContainer.close();
            } else {
                this.addTemplateArea(this.parent, true);
            }
        } else {
            assert (this.parent instanceof BlockContainerArea);
            boolean inlineElement = PropertyUtil.isInlineElement(this.content);
            if (!inlineElement) {
                BlockTextArea t = new BlockTextArea(this.parent, this.context, this.content);
                t.initialize();
                TextLineArea line = new TextLineArea(t, this.context);
                line.initialize();
                this.addTemplateArea(line, false);
                line.close();
                t.close();
            }
        }
    }

    protected TemplateArea createTemplateArea(IContent content, FontInfo fontInfo, int type) {
        TextStyle textStyle = TextAreaLayout.buildTextStyle(content, fontInfo);
        TemplateArea area = new TemplateArea(null, textStyle, type);
        area.setAction(content.getHyperlinkAction());
        return area;
    }

    protected void addTemplateArea(ContainerArea parent, boolean isInline) throws BirtException {
        IAutoTextContent autoText = (IAutoTextContent)this.content;
        FontHandler handler = new FontHandler(this.context.getFontManager(), autoText, false);
        FontInfo fontInfo = handler.getFontInfo();
        TemplateArea templateArea = this.createTemplateArea(this.content, fontInfo, autoText.getType());
        templateArea.setParent(parent);
        int maxWidth = parent.getCurrentMaxContentWidth();
        templateArea.setWidth(maxWidth - parent.getCurrentIP());
        int maxAvaWidth = templateArea.getWidth();
        int width = PropertyUtil.getDimensionValue(this.content, autoText.getWidth(), maxWidth);
        if (width == 0) {
            int defaultWidth = templateArea.getTextStyle().getFontSize() * 4;
            width = Math.min(maxAvaWidth, defaultWidth);
        } else if (width > maxAvaWidth) {
            width = maxAvaWidth;
        }
        templateArea.setWidth(width);
        this.context.setTotalPageTemplateWidth(templateArea.getWidth());
        int height = PropertyUtil.getDimensionValue(this.content, autoText.getHeight(), 0);
        templateArea.setHeight(Math.max((int)(fontInfo.getWordHeight() * 1000.0f), height));
        templateArea.setBaseLine(fontInfo.getBaseline() + templateArea.getY());
        parent.add(templateArea);
        templateArea.setParent(parent);
        parent.update(templateArea);
    }
}

