/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.extension.internal;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.IRowMetaData;
import org.eclipse.birt.report.engine.extension.IRowSet;
import org.eclipse.birt.report.engine.extension.internal.RowMetaData;

public class RowSet
implements IRowSet {
    protected IQueryResultSet rset;
    protected IRowMetaData metaData;
    protected ExecutionContext context;

    public RowSet(IQueryResultSet rset) throws BirtException {
        this.context = ((QueryResultSet)rset).getExecutionContext();
        this.rset = rset;
        this.metaData = new IRowMetaData(){

            public int getColumnCount() {
                return 0;
            }

            public String getColumnName(int index) throws BirtException {
                return null;
            }

            public int getColumnType(int index) throws BirtException {
                return -1;
            }
        };
        if (rset != null) {
            this.metaData = new RowMetaData(rset.getResultMetaData());
        }
    }

    public DataSetID getID() {
        return this.rset.getID();
    }

    public IRowMetaData getMetaData() {
        return this.metaData;
    }

    public boolean next() {
        if (this.rset != null) {
            try {
                return this.rset.next();
            }
            catch (BirtException ex) {
                this.context.addException(ex);
                return false;
            }
        }
        return false;
    }

    public Object evaluate(String expr) {
        try {
            if (this.rset != null) {
                return this.rset.evaluate(expr);
            }
        }
        catch (BirtException ex) {
            this.context.addException(ex);
        }
        return null;
    }

    public Object evaluate(IBaseExpression expr) {
        try {
            if (this.rset != null) {
                return this.rset.evaluate(expr);
            }
        }
        catch (BirtException ex) {
            this.context.addException(ex);
        }
        return null;
    }

    public Object getValue(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    public Object getValue(String columnName) {
        try {
            if (this.rset != null) {
                return this.rset.getValue(columnName);
            }
        }
        catch (BirtException ex) {
            this.context.addException(ex);
        }
        return null;
    }

    public int getEndingGroupLevel() {
        if (this.rset != null) {
            try {
                return this.rset.getEndingGroupLevel();
            }
            catch (BirtException ex) {
                this.context.addException(ex);
            }
        }
        return 0;
    }

    public int getStartingGroupLevel() {
        if (this.rset != null) {
            try {
                return this.rset.getStartingGroupLevel();
            }
            catch (BirtException ex) {
                this.context.addException(ex);
            }
        }
        return 0;
    }

    public void close() {
    }

    public boolean isEmpty() throws BirtException {
        if (this.rset == null) {
            return true;
        }
        return this.rset.isEmpty();
    }
}

