/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swing;

import java.awt.Shape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.device.g2d.G2dRendererBase;
import org.eclipse.birt.chart.device.swing.ShapedAction;
import org.eclipse.birt.chart.device.swing.SwingDisplayServer;
import org.eclipse.birt.chart.device.swing.SwingEventHandler;
import org.eclipse.birt.chart.device.swing.SwingTextRenderer;
import org.eclipse.birt.chart.event.ArcRenderEvent;
import org.eclipse.birt.chart.event.AreaRenderEvent;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.render.InteractiveRenderer;
import org.eclipse.birt.chart.util.PluginSettings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingRendererImpl
extends G2dRendererBase {
    private final Map<TriggerCondition, List<ShapedAction>> _lhmAllTriggers = new HashMap<TriggerCondition, List<ShapedAction>>();
    private final List<ShapedAction> _allShapes = new LinkedList<ShapedAction>();
    private IUpdateNotifier _iun = null;
    private SwingEventHandler _eh = null;
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.device.extension/swing");

    public SwingRendererImpl() {
        this.init();
    }

    protected void init() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this._ids = ps.getDisplayServer("ds.SWING");
            this._tr = new SwingTextRenderer(this._ids);
            this.iv = new InteractiveRenderer();
        }
        catch (ChartException pex) {
            logger.log(pex);
        }
    }

    @Override
    public void dispose() {
        Object obj;
        super.dispose();
        this._lhmAllTriggers.clear();
        if (this._iun != null && (obj = this._iun.peerInstance()) instanceof JComponent) {
            JComponent jc = (JComponent)obj;
            if (this._eh != null) {
                jc.removeMouseListener(this._eh);
                jc.removeMouseMotionListener(this._eh);
                jc.removeKeyListener(this._eh);
                jc.removeFocusListener(this._eh);
                this._eh = null;
            }
        }
    }

    @Override
    public void setProperty(String sProperty, Object oValue) {
        if (sProperty.equals("device.component") && this.iv != null) {
            this._iun = (IUpdateNotifier)oValue;
            this.iv.setUpdateNotifier(this._iun);
            this._lhmAllTriggers.clear();
            Object obj = this._iun.peerInstance();
            if (obj instanceof JComponent) {
                JComponent jc = (JComponent)obj;
                if (this._eh != null) {
                    jc.removeMouseListener(this._eh);
                    jc.removeMouseMotionListener(this._eh);
                    jc.removeKeyListener(this._eh);
                    jc.removeFocusListener(this._eh);
                }
                this._eh = new SwingEventHandler(this.iv, this._lhmAllTriggers, this._iun, this.getULocale());
                jc.addMouseListener(this._eh);
                jc.addMouseMotionListener(this._eh);
                jc.addKeyListener(this._eh);
                jc.addFocusListener(this._eh);
            }
        }
        super.setProperty(sProperty, oValue);
    }

    @Override
    protected void prepareGraphicsContext() {
        super.prepareGraphicsContext();
        logger.log(1, Messages.getString("SwingRendererImpl.info.using.graphics.context", new Object[]{this._g2d}, this.getULocale()));
    }

    protected void registerTriggers(Trigger[] tga, ShapedAction sa) {
        int i = 0;
        while (i < tga.length) {
            TriggerCondition tc = tga[i].getCondition();
            Action ac = tga[i].getAction();
            sa.add(tc, ac);
            List<ShapedAction> al = this._lhmAllTriggers.get((Object)tc);
            if (al == null) {
                al = new ArrayList<ShapedAction>(4);
                this._lhmAllTriggers.put(tc, al);
            }
            al.add(sa);
            ++i;
        }
        this._allShapes.add(sa);
    }

    @Override
    public void enableInteraction(InteractionEvent iev) throws ChartException {
        if (this._iun == null) {
            logger.log(1, Messages.getString("SwingRendererImpl.exception.missing.component.interaction", this.getULocale()));
            return;
        }
        Trigger[] tga = iev.getTriggers();
        if (tga == null) {
            return;
        }
        ShapedAction sa = this.getShapedAction(iev);
        if (sa != null) {
            sa.setCursor(iev.getCursor());
            sa.setZOrder(iev.getZOrder());
            this.registerTriggers(tga, sa);
        }
    }

    protected ShapedAction getShapedAction(InteractionEvent iev) {
        Shape clipping = this._g2d.getClip();
        PrimitiveRenderEvent pre = iev.getHotSpot();
        if (pre instanceof PolygonRenderEvent) {
            Location[] loa = ((PolygonRenderEvent)pre).getPoints();
            return new ShapedAction(iev.getStructureSource(), loa, clipping);
        }
        if (pre instanceof RectangleRenderEvent) {
            Bounds bo = ((RectangleRenderEvent)pre).getBounds();
            Location[] loa = new Location[]{goFactory.createLocation(bo.getLeft(), bo.getTop()), goFactory.createLocation(bo.getLeft(), bo.getTop() + bo.getHeight()), goFactory.createLocation(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getHeight()), goFactory.createLocation(bo.getLeft() + bo.getWidth(), bo.getTop())};
            return new ShapedAction(iev.getStructureSource(), loa, clipping);
        }
        if (pre instanceof OvalRenderEvent) {
            Bounds boEllipse = ((OvalRenderEvent)pre).getBounds();
            return new ShapedAction(iev.getStructureSource(), boEllipse, clipping);
        }
        if (pre instanceof ArcRenderEvent) {
            ArcRenderEvent are = (ArcRenderEvent)pre;
            Bounds boEllipse = are.getEllipseBounds();
            double dStart = are.getStartAngle();
            double dExtent = are.getAngleExtent();
            int iArcType = SwingRendererImpl.toG2dArcType(are.getStyle());
            return new ShapedAction(iev.getStructureSource(), boEllipse, dStart, dExtent, iArcType, clipping);
        }
        if (pre instanceof AreaRenderEvent) {
            Bounds bo = ((AreaRenderEvent)pre).getBounds();
            Location[] loa = new Location[]{goFactory.createLocation(bo.getLeft(), bo.getTop()), goFactory.createLocation(bo.getLeft(), bo.getTop() + bo.getHeight()), goFactory.createLocation(bo.getLeft() + bo.getWidth(), bo.getTop() + bo.getHeight()), goFactory.createLocation(bo.getLeft() + bo.getWidth(), bo.getTop())};
            return new ShapedAction(iev.getStructureSource(), loa, clipping);
        }
        return null;
    }

    public static String csSearchAndReplace(String s, String sWordToReplace, String sReplaceWith) {
        int i = 0;
        do {
            if ((i = s.indexOf(sWordToReplace, i)) == -1) continue;
            s = String.valueOf(s.substring(0, i)) + sReplaceWith + s.substring(i + sWordToReplace.length());
            i += sReplaceWith.length();
        } while (i != -1);
        return s;
    }

    protected Map<TriggerCondition, List<ShapedAction>> getTriggers() {
        return this._lhmAllTriggers;
    }

    protected List<ShapedAction> getShapeActions() {
        return this._allShapes;
    }

    @Override
    public void before() throws ChartException {
        this._lhmAllTriggers.clear();
    }

    @Override
    public void after() throws ChartException {
        ((SwingDisplayServer)this._ids).getImageCache().flush();
    }
}

