/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.math.BigDecimal;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class BooleanPropertyType
extends PropertyType {
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String BOOLEAN_TRUE_RESOURCE_KEY = "Property.Boolean.True";
    public static final String BOOLEAN_FALSE_RESOURCE_KEY = "Property.Boolean.False";
    public static final int INT_TRUE = 1;
    public static final int INT_FALSE = 0;
    private static final String DISPLAY_NAME_KEY = "Property.boolean";

    public BooleanPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public Object validateValue(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.validateInputString(module, element, defn, (String)value);
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Integer || value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
            return ((Number)value).intValue() == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", this.getTypeCode());
    }

    public Object validateXml(Module module, DesignElement element, PropertyDefn defn, Object value) throws PropertyValueException {
        assert (value == null || value instanceof String);
        String tmpValue = (String)value;
        if ((tmpValue = StringUtil.trimString(tmpValue)) == null) {
            return null;
        }
        if (tmpValue.equalsIgnoreCase(TRUE)) {
            return Boolean.TRUE;
        }
        if (tmpValue.equalsIgnoreCase(FALSE)) {
            return Boolean.FALSE;
        }
        throw new PropertyValueException((Object)tmpValue, "Error.PropertyValueException.INVALID_VALUE", this.getTypeCode());
    }

    public int getTypeCode() {
        return 6;
    }

    public String getName() {
        return "boolean";
    }

    public int toInteger(Module module, Object value) {
        if (value == null) {
            return 0;
        }
        return (Boolean)value != false ? 1 : 0;
    }

    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        return (Boolean)value != false ? TRUE : FALSE;
    }

    public boolean toBoolean(Module module, Object value) {
        if (value == null) {
            return false;
        }
        return (Boolean)value;
    }

    public Object validateInputString(Module module, DesignElement element, PropertyDefn defn, String value) throws PropertyValueException {
        if (StringUtil.isBlank(value)) {
            return null;
        }
        if (value.equalsIgnoreCase(TRUE)) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase(FALSE)) {
            return Boolean.FALSE;
        }
        if (value.equalsIgnoreCase(ModelMessages.getMessage(BOOLEAN_TRUE_RESOURCE_KEY))) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase(ModelMessages.getMessage(BOOLEAN_FALSE_RESOURCE_KEY))) {
            return Boolean.FALSE;
        }
        throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 6);
    }

    public String toDisplayString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        if (((Boolean)value).booleanValue()) {
            return ModelMessages.getMessage(BOOLEAN_TRUE_RESOURCE_KEY);
        }
        return ModelMessages.getMessage(BOOLEAN_FALSE_RESOURCE_KEY);
    }
}

