/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.extension;

import java.io.InputStream;
import java.util.Locale;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.api.IHTMLActionHandler;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemPresentation;
import org.eclipse.birt.report.engine.extension.IReportItemPresentationInfo;
import org.eclipse.birt.report.engine.extension.IRowSet;
import org.eclipse.birt.report.engine.extension.Size;
import org.eclipse.birt.report.engine.extension.internal.RowSet;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;

public class ReportItemPresentationBase
implements IReportItemPresentation {
    protected IReportItemPresentationInfo info;
    protected ExtendedItemHandle modelHandle;
    protected ClassLoader appClassLoader;
    protected IReportContext context;
    protected int dpi = 72;
    protected String outputFormat;
    protected String supportedImageFormats;
    protected Locale locale;
    protected IDataQueryDefinition[] queries;
    protected IHTMLActionHandler ah = null;
    protected IStyle style = null;
    protected IContent content = null;

    public void init(IReportItemPresentationInfo info) {
        if (info == null) {
            throw new NullPointerException();
        }
        this.info = info;
        this.setModelObject(info.getModelObject());
        this.setApplicationClassLoader(info.getApplicationClassLoader());
        this.setScriptContext(info.getReportContext());
        this.setReportQueries(info.getReportQueries());
        this.setDynamicStyle(info.getExtendedItemContent().getComputedStyle());
        this.setResolution(info.getResolution());
        this.setLocale(info.getReportContext().getLocale());
        this.setExtendedItemContent(info.getExtendedItemContent());
        this.setSupportedImageFormats(info.getSupportedImageFormats());
        this.setActionHandler(info.getActionHandler());
        this.setOutputFormat(info.getOutputFormat());
    }

    public int getOutputType() {
        return 0;
    }

    public Object getOutputContent() {
        return null;
    }

    public Size getSize() {
        return null;
    }

    public void finish() {
    }

    public void setModelObject(ExtendedItemHandle modelHandle) {
        this.modelHandle = modelHandle;
    }

    public void setApplicationClassLoader(ClassLoader loader) {
        this.appClassLoader = loader;
    }

    public void setScriptContext(IReportContext context) {
        this.context = context;
    }

    public void setReportQueries(IDataQueryDefinition[] queries) {
        this.queries = queries;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setResolution(int dpi) {
        this.dpi = dpi;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void setSupportedImageFormats(String supportedImageFormats) {
        this.supportedImageFormats = supportedImageFormats;
    }

    public void deserialize(InputStream istream) {
    }

    public Object onRowSets(IRowSet[] rowSets) throws BirtException {
        return null;
    }

    public Object onRowSets(IBaseResultSet[] results) throws BirtException {
        if (results == null) {
            return this.onRowSets((IRowSet[])null);
        }
        int length = results.length;
        int i = 0;
        while (i < length) {
            if (results[i].getType() == 1) {
                return null;
            }
            ++i;
        }
        IRowSet[] rowSets = new IRowSet[length];
        int index = 0;
        while (index < length) {
            IQueryResultSet resultSet = (IQueryResultSet)results[index];
            rowSets[index] = new RowSet(resultSet);
            ++index;
        }
        return this.onRowSets(rowSets);
    }

    public String getImageMIMEType() {
        return "";
    }

    public void setActionHandler(IHTMLActionHandler ah) {
        this.ah = ah;
    }

    public void setDynamicStyle(IStyle style) {
        this.style = style;
    }

    public void setExtendedItemContent(IContent content) {
        this.content = content;
    }

    public IReportItemPresentationInfo getPresentationConfig() {
        return this.info;
    }
}

