/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine.value.css;

import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.CSSEngine;
import org.eclipse.birt.report.engine.css.engine.CSSStylableElement;
import org.eclipse.birt.report.engine.css.engine.value.AbstractLengthManager;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.StringMap;
import org.eclipse.birt.report.engine.css.engine.value.Value;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class LineHeightManager
extends AbstractLengthManager {
    protected static final StringMap values = new StringMap();

    static {
        values.put("normal", CSSValueConstants.NORMAL_VALUE);
    }

    public String getPropertyName() {
        return "line-height";
    }

    public boolean isInheritedProperty() {
        return true;
    }

    public Value getDefaultValue() {
        return CSSValueConstants.NORMAL_VALUE;
    }

    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case 35: {
                String s = lu.getStringValue().toLowerCase().intern();
                Object v = values.get(s);
                if (v == null) {
                    throw this.createInvalidIdentifierDOMException(lu.getStringValue());
                }
                return (Value)v;
            }
        }
        return super.createValue(lu, engine);
    }

    public Value computeValue(CSSStylableElement elt, CSSEngine engine, int idx, Value value) {
        if (value.getCssValueType() == 1) {
            switch (value.getPrimitiveType()) {
                case 21: {
                    return value;
                }
                case 2: {
                    float scale = value.getFloatValue();
                    IStyle cs = elt.getComputedStyle();
                    assert (cs != null);
                    Value fontSize = (Value)cs.getProperty(44);
                    assert (fontSize != null);
                    float fs = fontSize.getFloatValue();
                    return new FloatValue(fontSize.getPrimitiveType(), fs * scale / 100.0f);
                }
            }
        }
        return super.computeValue(elt, engine, idx, value);
    }
}

