/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.ir.TextItemDesign;

public class TextContent
extends AbstractContent
implements ITextContent {
    protected String text;
    protected String textKey;
    protected String textType;
    protected static final short FIELD_TEXT = 1100;

    TextContent(ITextContent textContent) {
        super(textContent);
        this.text = textContent.getText();
    }

    public int getContentType() {
        return 11;
    }

    TextContent(ReportContent report) {
        super(report);
    }

    TextContent(IContent content) {
        super(content);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Object accept(IContentVisitor visitor, Object value) throws BirtException {
        return visitor.visitText(this, value);
    }

    public void setTextKey(String key) {
        this.textKey = key;
    }

    public String getTextKey() {
        if (this.textKey != null) {
            return this.textKey;
        }
        if (this.generateBy instanceof TextItemDesign) {
            return ((TextItemDesign)this.generateBy).getTextKey();
        }
        return null;
    }

    public void setTextType(String type) {
        this.textType = type;
    }

    public String getTextType() {
        if (this.textType != null) {
            return this.textType;
        }
        if (this.generateBy instanceof TextItemDesign) {
            return ((TextItemDesign)this.generateBy).getTextType();
        }
        return null;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.text != null) {
            IOUtil.writeShort(out, (short)1100);
            IOUtil.writeString(out, this.text);
        }
    }

    protected void readField(int version, int filedId, DataInputStream in, ClassLoader loader) throws IOException {
        switch (filedId) {
            case 1100: {
                this.text = IOUtil.readString(in);
                break;
            }
            default: {
                super.readField(version, filedId, in, loader);
            }
        }
    }

    public boolean needSave() {
        if (this.text != null) {
            return true;
        }
        return super.needSave();
    }

    protected IContent cloneContent() {
        return new TextContent(this);
    }
}

