/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.IReportDocument;

public class RunStatusReader {
    protected RAInputStream runStatusStream;
    protected static Logger logger = Logger.getLogger(RunStatusReader.class.getName());

    public RunStatusReader(IReportDocument document) {
        try {
            IDocArchiveReader reader = document.getArchive();
            boolean existStream = reader.exists("/runStatus");
            if (existStream) {
                this.runStatusStream = reader.getStream("/runStatus");
            }
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Unable to create stream to read run task status");
            this.close();
        }
    }

    public void close() {
        try {
            if (this.runStatusStream != null) {
                this.runStatusStream.close();
                this.runStatusStream = null;
            }
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Unable to close the stream reading run task status");
        }
    }

    public String getStuats() {
        if (this.runStatusStream == null) {
            return null;
        }
        try {
            DataInputStream in = new DataInputStream(this.runStatusStream);
            int errorSize = IOUtil.readInt(in);
            if (errorSize > 0) {
                StringBuilder message = new StringBuilder();
                int i = 0;
                while (i < errorSize) {
                    message.append(IOUtil.readString(in)).append("\n");
                    ++i;
                }
                return message.toString();
            }
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, "Exception occured during reading run task status");
        }
        return null;
    }
}

