/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.btree;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.eclipse.birt.core.btree.BTree;
import org.eclipse.birt.core.btree.BTreeConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BTreeNode<K, V>
implements BTreeConstants {
    protected BTree<K, V> btree;
    protected int nodeType;
    protected int nodeId;
    protected int[] usedBlocks;
    protected int lockCount;
    protected boolean dirty;

    BTreeNode(BTree<K, V> tree, int type, int id) {
        this.btree = tree;
        this.nodeType = type;
        this.nodeId = id;
        this.dirty = true;
        this.lockCount = 0;
        this.usedBlocks = new int[]{id};
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    abstract void read(DataInput var1) throws IOException;

    abstract void write(DataOutput var1) throws IOException;

    public void lock() {
        ++this.lockCount;
    }

    public void unlock() {
        --this.lockCount;
    }

    public boolean isLocked() {
        return this.lockCount != 0;
    }

    public void setUsedBlocks(int[] usedBlocks) {
        this.usedBlocks = usedBlocks;
    }

    public int[] getUsedBlocks() {
        return this.usedBlocks;
    }

    abstract void dumpAll() throws IOException;

    abstract void dumpNode() throws IOException;
}

