/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.factory.ActionEvaluatorAdapter;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.MultiURLValues;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.MultipleActions;
import org.eclipse.birt.chart.model.impl.ChartModelHelper;
import org.eclipse.birt.chart.util.ChartExpressionUtil;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.ExpressionListHandle;
import org.eclipse.birt.report.model.api.ModuleUtil;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.SearchKeyHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BIRTActionEvaluator
extends ActionEvaluatorAdapter {
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.reportitem/trace");
    protected final ChartExpressionUtil.ExpressionCodec exprCodec = ChartModelHelper.instance().createExpressionCodec();
    private ActionHandleCache actionHandleCache = new ActionHandleCache();

    @Override
    public String[] getActionExpressions(Action action, StructureSource source) {
        TooltipValue tv;
        String exp;
        if (action instanceof MultipleActions) {
            ArrayList<String> expList = new ArrayList<String>();
            for (Action subAction : ((MultipleActions)action).getActions()) {
                if (!(subAction.getValue() instanceof URLValue)) continue;
                this.getURLValueExpressions(expList, (URLValue)subAction.getValue());
            }
            if (expList.size() > 0) {
                return expList.toArray(new String[expList.size()]);
            }
        } else if (ActionType.URL_REDIRECT_LITERAL.equals((Object)action.getType())) {
            ArrayList<String> expList = new ArrayList<String>();
            if (action.getValue() instanceof URLValue) {
                URLValue uv = (URLValue)action.getValue();
                this.getURLValueExpressions(expList, uv);
            } else if (action.getValue() instanceof MultiURLValues) {
                for (URLValue uv : ((MultiURLValues)action.getValue()).getURLValues()) {
                    this.getURLValueExpressions(expList, uv);
                }
            }
            if (expList.size() > 0) {
                return expList.toArray(new String[expList.size()]);
            }
        } else if (ActionType.SHOW_TOOLTIP_LITERAL.equals((Object)action.getType()) && StructureType.SERIES.equals(source.getType()) && (exp = (tv = (TooltipValue)action.getValue()).getText()) != null && exp.trim().length() > 0) {
            return new String[]{exp};
        }
        return null;
    }

    private void getURLValueExpressions(List<String> expList, URLValue uv) {
        String sa = uv.getBaseUrl();
        try {
            ActionHandle handle = this.actionHandleCache.get(sa);
            if ("hyperlink".equals(handle.getLinkType())) {
                String exp;
                ExpressionHandle expHandle = handle.getExpressionProperty("uri");
                if ("javascript".equals(expHandle.getType()) && !expList.contains(exp = expHandle.getStringExpression())) {
                    expList.add(exp);
                }
            } else if ("bookmark-link".equals(handle.getLinkType())) {
                ExpressionHandle exprHandle = handle.getExpressionProperty("targetBookmark");
                this.exprCodec.setExpression(exprHandle.getStringValue());
                this.exprCodec.setType(exprHandle.getType());
                String exp = this.exprCodec.encode();
                if (!expList.contains(exp)) {
                    expList.add(exp);
                }
            } else if ("drill-through".equals(handle.getLinkType())) {
                ExpressionHandle exprHandle = handle.getExpressionProperty("targetBookmark");
                this.exprCodec.setExpression(exprHandle.getStringValue());
                this.exprCodec.setType(exprHandle.getType());
                String exp = this.exprCodec.encode();
                if (exp != null && !expList.contains(exp)) {
                    expList.add(exp);
                }
                Iterator itr = handle.getSearch().iterator();
                while (itr.hasNext()) {
                    SearchKeyHandle skh = (SearchKeyHandle)itr.next();
                    exp = skh.getExpression();
                    if (expList.contains(exp)) continue;
                    expList.add(exp);
                }
                itr = handle.getParamBindings().iterator();
                while (itr.hasNext()) {
                    ParamBindingHandle pbh = (ParamBindingHandle)itr.next();
                    ExpressionListHandle exprListHandle = pbh.getExpressionListHandle();
                    List<Expression> listValue = exprListHandle.getListValue();
                    if (listValue == null) continue;
                    for (Expression expr : listValue) {
                        this.exprCodec.setExpression(expr.getStringExpression());
                        this.exprCodec.setType(expr.getType());
                        exp = this.exprCodec.encode();
                        if (expList.contains(exp)) continue;
                        expList.add(exp);
                    }
                }
            }
        }
        catch (DesignFileException e) {
            logger.log(e);
        }
    }

    private static class ActionHandleCache {
        private Map<String, ActionHandle> hm = new HashMap<String, ActionHandle>();

        private ActionHandleCache() {
        }

        public ActionHandle get(String key) throws DesignFileException {
            ActionHandle value = this.hm.get(key);
            if (value == null) {
                value = this.newValue(key);
                this.hm.put(key, value);
            }
            return value;
        }

        protected ActionHandle newValue(String key) throws DesignFileException {
            return ModuleUtil.deserializeAction(key);
        }
    }
}

