/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.fest.util.IntrospectionError;
import org.fest.util.Strings;

public final class Introspection {
    public static PropertyDescriptor descriptorForProperty(String propertyName, Object target) {
        Introspection.validate(propertyName, target);
        BeanInfo beanInfo = null;
        Class<?> type = target.getClass();
        try {
            beanInfo = Introspector.getBeanInfo(type, Object.class);
        }
        catch (Exception e) {
            throw new IntrospectionError(Strings.concat("Unable to get BeanInfo for type ", type.getName()), e);
        }
        for (PropertyDescriptor d : beanInfo.getPropertyDescriptors()) {
            if (!propertyName.equals(d.getName())) continue;
            return d;
        }
        throw new IntrospectionError(Strings.concat("Unable to find property ", Strings.quote(propertyName), " in ", type.getName()));
    }

    private static void validate(String propertyName, Object target) {
        if (propertyName == null) {
            throw new NullPointerException("The property name should not be null");
        }
        if (Strings.isEmpty(propertyName)) {
            throw new IllegalArgumentException("The property name should not be empty");
        }
        if (target == null) {
            throw new NullPointerException("The target object should not be null");
        }
    }

    private Introspection() {
    }
}

