/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import org.fest.util.Arrays;

public final class Strings {
    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String quote(String s) {
        return s != null ? Strings.concat("'", s, "'") : null;
    }

    public static Object quote(Object o) {
        return o instanceof String ? Strings.quote(o.toString()) : o;
    }

    public static String concat(Object ... objects) {
        if (Arrays.isEmpty(objects)) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            b.append(o);
            ++n2;
        }
        return b.toString();
    }

    public static StringsToJoin join(String ... strings) {
        return new StringsToJoin(strings);
    }

    public static StringToAppend append(String toAppend) {
        return new StringToAppend(toAppend);
    }

    private Strings() {
    }

    public static class StringToAppend {
        private final String toAppend;

        StringToAppend(String toAppend) {
            this.toAppend = toAppend;
        }

        public String to(String s) {
            if (!s.endsWith(this.toAppend)) {
                return Strings.concat(s, this.toAppend);
            }
            return s;
        }
    }

    public static class StringsToJoin {
        private final String[] strings;

        StringsToJoin(String ... strings) {
            this.strings = strings;
        }

        public String with(String delimeter) {
            if (delimeter == null) {
                throw new IllegalArgumentException("Delimiter should not be null");
            }
            if (Arrays.isEmpty(this.strings)) {
                return "";
            }
            StringBuilder b = new StringBuilder();
            int stringCount = this.strings.length;
            int i = 0;
            while (i < stringCount) {
                String s = this.strings[i];
                b.append(s != null ? s : "");
                if (i < stringCount - 1) {
                    b.append(delimeter);
                }
                ++i;
            }
            return b.toString();
        }
    }
}

