/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fest.util.Collections;
import org.fest.util.Introspection;
import org.fest.util.IntrospectionError;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PropertySupport {
    private static final String SEPARATOR = ".";

    static List<Object> propertyValues(String propertyName, Collection<?> target) {
        if (Collections.isEmpty(target) || Collections.hasOnlyNullElements(target)) {
            return java.util.Collections.emptyList();
        }
        Collection nonNullElements = Collections.nonNullElements(target);
        if (PropertySupport.isNestedProperty(propertyName)) {
            String firstProperty = PropertySupport.firstPropertyIfNested(propertyName);
            List<Object> firstPropertyValues = PropertySupport.propertyValues(firstProperty, nonNullElements);
            return PropertySupport.propertyValues(PropertySupport.removeFirstPropertyIfNested(propertyName), firstPropertyValues);
        }
        return PropertySupport.simplePropertyValues(propertyName, nonNullElements);
    }

    static boolean isNestedProperty(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("The property name to verify should not be null");
        }
        return propertyName.contains(SEPARATOR) && !propertyName.startsWith(SEPARATOR) && !propertyName.endsWith(SEPARATOR);
    }

    static String removeFirstPropertyIfNested(String propertyName) {
        if (!PropertySupport.isNestedProperty(propertyName)) {
            return "";
        }
        return propertyName.substring(propertyName.indexOf(SEPARATOR) + 1);
    }

    static String firstPropertyIfNested(String propertyName) {
        if (!PropertySupport.isNestedProperty(propertyName)) {
            return propertyName;
        }
        return propertyName.substring(0, propertyName.indexOf(SEPARATOR));
    }

    private static List<Object> simplePropertyValues(String propertyName, Collection<?> target) {
        ArrayList<Object> propertyValues = new ArrayList<Object>();
        for (Object e : target) {
            propertyValues.add(PropertySupport.propertyValue(propertyName, e));
        }
        return propertyValues;
    }

    private static Object propertyValue(String propertyName, Object target) {
        PropertyDescriptor descriptor = Introspection.descriptorForProperty((String)propertyName, (Object)target);
        try {
            return descriptor.getReadMethod().invoke(target, new Object[0]);
        }
        catch (Exception e) {
            throw new IntrospectionError(Strings.concat((Object[])new Object[]{"Unable to obtain the value in property " + Strings.quote((String)propertyName)}), (Throwable)e);
        }
    }

    private PropertySupport() {
    }
}

