/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.Formatting;
import org.fest.assertions.Index;
import org.fest.assertions.ObjectGroupAssert;
import org.fest.assertions.PropertySupport;
import org.fest.util.Collections;
import org.fest.util.Objects;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListAssert
extends ObjectGroupAssert<List<?>> {
    protected ListAssert(List<?> actual) {
        super(actual);
    }

    public ListAssert contains(Object o, Index index) {
        Object actualElement;
        if (index == null) {
            throw new NullPointerException(this.formattedErrorMessage("The given index should not be null"));
        }
        this.isNotNull().isNotEmpty();
        int indexValue = index.value();
        int listSize = this.actualGroupSize();
        if (indexValue < 0 || indexValue >= listSize) {
            this.failIndexOutOfBounds(indexValue);
        }
        if (!Objects.areEqual(actualElement = ((List)this.actual).get(indexValue), (Object)o)) {
            this.failElementNotFound(o, actualElement, indexValue);
        }
        return this;
    }

    private void failElementNotFound(Object e, Object a, int index) {
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat((Object[])new Object[]{"expecting ", Formatting.inBrackets(e), " at index ", Formatting.inBrackets(index), " but found ", Formatting.inBrackets(a)}));
    }

    private void failIndexOutOfBounds(int index) {
        throw new IndexOutOfBoundsException(this.formattedErrorMessage(Strings.concat((Object[])new Object[]{"The index ", Formatting.inBrackets(index), " should be greater than or equal to zero and less than ", this.actualGroupSize()})));
    }

    public ListAssert containsSequence(Object ... sequence) {
        this.isNotNull();
        this.validateIsNotNull(sequence);
        int sequenceSize = sequence.length;
        if (sequenceSize == 0) {
            return this;
        }
        int indexOfFirst = ((List)this.actual).indexOf(sequence[0]);
        if (indexOfFirst == -1) {
            this.failIfSequenceNotFound(sequence);
        }
        int listSize = this.actualGroupSize();
        for (int i = 0; i < sequenceSize; ++i) {
            int actualIndex = indexOfFirst + i;
            if (actualIndex > listSize - 1) {
                this.failIfSequenceNotFound(sequence);
            }
            if (Objects.areEqual((Object)sequence[i], ((List)this.actual).get(actualIndex))) continue;
            this.failIfSequenceNotFound(sequence);
        }
        return this;
    }

    private void failIfSequenceNotFound(Object[] notFound) {
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat((Object[])new Object[]{"list:", Formatting.inBrackets(this.actual), " does not contain the sequence:", Formatting.inBrackets(notFound)}));
    }

    public ListAssert startsWith(Object ... sequence) {
        this.isNotNull();
        this.validateIsNotNull(sequence);
        int sequenceSize = sequence.length;
        int listSize = this.actualGroupSize();
        if (sequenceSize == 0 && listSize == 0) {
            return this;
        }
        if (sequenceSize == 0 && listSize != 0) {
            this.failIfNotStartingWithSequence(sequence);
        }
        if (listSize < sequenceSize) {
            this.failIfNotStartingWithSequence(sequence);
        }
        for (int i = 0; i < sequenceSize; ++i) {
            if (Objects.areEqual((Object)sequence[i], ((List)this.actual).get(i))) continue;
            this.failIfNotStartingWithSequence(sequence);
        }
        return this;
    }

    private void failIfNotStartingWithSequence(Object[] notFound) {
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat((Object[])new Object[]{"list:", Formatting.inBrackets(this.actual), " does not start with the sequence:", Formatting.inBrackets(notFound)}));
    }

    public ListAssert endsWith(Object ... sequence) {
        this.isNotNull();
        this.validateIsNotNull(sequence);
        int sequenceSize = sequence.length;
        int listSize = this.actualGroupSize();
        if (sequenceSize == 0 && listSize == 0) {
            return this;
        }
        if (sequenceSize == 0 && listSize != 0) {
            this.failIfNotEndingWithSequence(sequence);
        }
        if (listSize < sequenceSize) {
            this.failIfNotEndingWithSequence(sequence);
        }
        for (int i = 0; i < sequenceSize; ++i) {
            int sequenceIndex = sequenceSize - 1 - i;
            int listIndex = listSize - 1 - i;
            if (Objects.areEqual((Object)sequence[sequenceIndex], ((List)this.actual).get(listIndex))) continue;
            this.failIfNotEndingWithSequence(sequence);
        }
        return this;
    }

    private void failIfNotEndingWithSequence(Object[] notFound) {
        this.failIfCustomMessageIsSet();
        this.fail(Strings.concat((Object[])new Object[]{"list:", Formatting.inBrackets(this.actual), " does not end with the sequence:", Formatting.inBrackets(notFound)}));
    }

    public ListAssert contains(Object ... objects) {
        this.assertContains(objects);
        return this;
    }

    public ListAssert containsOnly(Object ... objects) {
        this.assertContainsOnly(objects);
        return this;
    }

    public ListAssert excludes(Object ... objects) {
        this.assertExcludes(objects);
        return this;
    }

    public ListAssert doesNotHaveDuplicates() {
        this.assertDoesNotHaveDuplicates();
        return this;
    }

    @Override
    public ListAssert as(String description) {
        this.description(description);
        return this;
    }

    @Override
    public ListAssert describedAs(String description) {
        return this.as(description);
    }

    @Override
    public ListAssert as(Description description) {
        this.description(description);
        return this;
    }

    @Override
    public ListAssert describedAs(Description description) {
        return this.as(description);
    }

    public ListAssert satisfies(Condition<List<?>> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public ListAssert doesNotSatisfy(Condition<List<?>> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public ListAssert is(Condition<List<?>> condition) {
        this.assertIs(condition);
        return this;
    }

    public ListAssert isNot(Condition<List<?>> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public ListAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    public ListAssert isNotEmpty() {
        this.assertIsNotEmpty();
        return this;
    }

    @Override
    protected int actualGroupSize() {
        this.isNotNull();
        return ((List)this.actual).size();
    }

    public ListAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public ListAssert containsExactly(Object ... objects) {
        this.validateIsNotNull(objects);
        return this.isNotNull().isEqualTo(Collections.list((Object[])objects));
    }

    public ListAssert isEqualTo(List<?> expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public ListAssert isNotEqualTo(List<?> other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public ListAssert isSameAs(List<?> expected) {
        this.assertSameAs(expected);
        return this;
    }

    public ListAssert isNotSameAs(List<?> other) {
        this.assertNotSameAs(other);
        return this;
    }

    @Override
    public ListAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }

    public ListAssert onProperty(String propertyName) {
        this.isNotNull();
        if (((List)this.actual).isEmpty()) {
            return new ListAssert(java.util.Collections.emptyList());
        }
        return new ListAssert(PropertySupport.propertyValues(propertyName, (Collection)this.actual));
    }

    @Override
    protected Set<Object> actualAsSet() {
        return new HashSet<Object>((Collection)this.actual);
    }

    @Override
    protected List<Object> actualAsList() {
        return new ArrayList<Object>((Collection)this.actual);
    }
}

