/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.NumberAssert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntAssert
extends GenericAssert<Integer>
implements NumberAssert {
    private static final int ZERO = 0;

    protected IntAssert(int actual) {
        super(actual);
    }

    protected IntAssert(Integer actual) {
        super(actual);
    }

    public IntAssert as(String description) {
        this.description(description);
        return this;
    }

    public IntAssert describedAs(String description) {
        return this.as(description);
    }

    public IntAssert as(Description description) {
        this.description(description);
        return this;
    }

    public IntAssert describedAs(Description description) {
        return this.as(description);
    }

    public IntAssert isEqualTo(int expected) {
        return this.isEqualTo((Integer)expected);
    }

    public IntAssert isEqualTo(Integer expected) {
        this.assertEqualTo(expected);
        return this;
    }

    public IntAssert isNotEqualTo(int other) {
        return this.isNotEqualTo((Integer)other);
    }

    public IntAssert isNotEqualTo(Integer other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public IntAssert isGreaterThan(int other) {
        if ((Integer)this.actual > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    public IntAssert isLessThan(int other) {
        if ((Integer)this.actual < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    public IntAssert isGreaterThanOrEqualTo(int other) {
        if ((Integer)this.actual >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    public IntAssert isLessThanOrEqualTo(int other) {
        if ((Integer)this.actual <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    @Override
    public IntAssert isZero() {
        return this.isEqualTo(0);
    }

    @Override
    public IntAssert isPositive() {
        return this.isGreaterThan(0);
    }

    @Override
    public IntAssert isNegative() {
        return this.isLessThan(0);
    }

    public IntAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }

    public IntAssert satisfies(Condition<Integer> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public IntAssert doesNotSatisfy(Condition<Integer> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public IntAssert is(Condition<Integer> condition) {
        this.assertIs(condition);
        return this;
    }

    public IntAssert isNot(Condition<Integer> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public IntAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public IntAssert isSameAs(Integer expected) {
        this.assertSameAs(expected);
        return this;
    }

    public IntAssert isNotSameAs(Integer other) {
        this.assertNotSameAs(other);
        return this;
    }
}

