/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Assert;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.Fail;
import org.fest.assertions.Formatting;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericAssert<T>
extends Assert {
    protected final T actual;

    protected GenericAssert(T actual) {
        this.actual = actual;
    }

    public final void isNull() {
        Fail.failIfNotNull(this.customErrorMessage(), this.rawDescription(), this.actual);
    }

    protected abstract GenericAssert<T> satisfies(Condition<T> var1);

    protected abstract GenericAssert<T> doesNotSatisfy(Condition<T> var1);

    protected abstract GenericAssert<T> is(Condition<T> var1);

    protected abstract GenericAssert<T> isNot(Condition<T> var1);

    protected abstract GenericAssert<T> as(String var1);

    protected abstract GenericAssert<T> describedAs(String var1);

    protected abstract GenericAssert<T> as(Description var1);

    protected abstract GenericAssert<T> describedAs(Description var1);

    protected abstract GenericAssert<T> isEqualTo(T var1);

    protected abstract GenericAssert<T> isNotEqualTo(T var1);

    protected abstract GenericAssert<T> isNotNull();

    protected abstract GenericAssert<T> isSameAs(T var1);

    protected abstract GenericAssert<T> isNotSameAs(T var1);

    protected final void assertSatisfies(Condition<T> condition) {
        if (this.matches(condition)) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(this.errorMessageIfConditionNotSatisfied(condition));
    }

    private String errorMessageIfConditionNotSatisfied(Condition<T> condition) {
        String message = Strings.concat((Object[])new Object[]{"actual value:", Formatting.inBrackets(this.actual), " should satisfy condition"});
        return condition.addDescriptionTo(message);
    }

    protected final void assertIs(Condition<T> condition) {
        if (this.matches(condition)) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(this.errorMessageIfIsNot(condition));
    }

    private String errorMessageIfIsNot(Condition<T> condition) {
        String message = Strings.concat((Object[])new Object[]{"actual value:", Formatting.inBrackets(this.actual), " should be"});
        return condition.addDescriptionTo(message);
    }

    protected final void assertDoesNotSatisfy(Condition<T> condition) {
        if (!this.matches(condition)) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(this.errorMessageIfConditionSatisfied(condition));
    }

    private String errorMessageIfConditionSatisfied(Condition<T> condition) {
        String message = Strings.concat((Object[])new Object[]{"actual value:", Formatting.inBrackets(this.actual), " should not satisfy condition"});
        return condition.addDescriptionTo(message);
    }

    protected final void assertIsNot(Condition<T> condition) {
        if (!this.matches(condition)) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(this.errorMessageIfIs(condition));
    }

    private boolean matches(Condition<T> condition) {
        this.validateIsNotNull(condition);
        return condition.matches(this.actual);
    }

    private void validateIsNotNull(Condition<T> condition) {
        if (condition == null) {
            throw new NullPointerException("Condition to check should not be null");
        }
    }

    private String errorMessageIfIs(Condition<T> condition) {
        String message = Strings.concat((Object[])new Object[]{"actual value:", Formatting.inBrackets(this.actual), " should not be"});
        return condition.addDescriptionTo(message);
    }

    protected final void assertEqualTo(T expected) {
        Fail.failIfNotEqual(this.customErrorMessage(), this.rawDescription(), this.actual, expected);
    }

    protected final void assertNotEqualTo(T other) {
        Fail.failIfEqual(this.customErrorMessage(), this.rawDescription(), this.actual, other);
    }

    protected final void assertNotNull() {
        Fail.failIfActualIsNull(this.customErrorMessage(), this.rawDescription(), this.actual);
    }

    protected final void assertSameAs(T expected) {
        Fail.failIfNotSame(this.customErrorMessage(), this.rawDescription(), this.actual, expected);
    }

    protected final void assertNotSameAs(T expected) {
        Fail.failIfSame(this.customErrorMessage(), this.rawDescription(), this.actual, expected);
    }

    protected abstract GenericAssert<T> overridingErrorMessage(String var1);
}

