/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Fail;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.NumberAssert;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatAssert
extends GenericAssert<Float>
implements NumberAssert {
    private static final float ZERO = 0.0f;

    protected FloatAssert(float actual) {
        super(Float.valueOf(actual));
    }

    protected FloatAssert(Float actual) {
        super(actual);
    }

    public FloatAssert as(String description) {
        this.description(description);
        return this;
    }

    public FloatAssert describedAs(String description) {
        return this.as(description);
    }

    public FloatAssert as(Description description) {
        this.description(description);
        return this;
    }

    public FloatAssert describedAs(Description description) {
        return this.as(description);
    }

    public FloatAssert isEqualTo(float expected) {
        return this.isEqualTo(Float.valueOf(expected));
    }

    public FloatAssert isEqualTo(Float expected) {
        if (this.actual == null || expected == null) {
            this.assertEqualTo(expected);
            return this;
        }
        if (((Float)this.actual).compareTo(expected) == 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw Fail.comparisonFailed(this.rawDescription(), this.actual, expected);
    }

    @Deprecated
    public FloatAssert isEqualTo(float expected, Delta delta) {
        return this.isEqualTo(expected, delta.value);
    }

    public FloatAssert isEqualTo(float expected, org.fest.assertions.Delta delta) {
        return this.isEqualTo(expected, delta.floatValue());
    }

    private FloatAssert isEqualTo(float expected, float deltaValue) {
        return this.isEqualTo(Float.valueOf(expected), deltaValue);
    }

    public FloatAssert isEqualTo(Float expected, org.fest.assertions.Delta delta) {
        return this.isEqualTo(expected, delta.floatValue());
    }

    private FloatAssert isEqualTo(Float expected, float deltaValue) {
        if (this.actual == null || expected == null) {
            this.assertEqualTo(expected);
            return this;
        }
        if (((Float)this.actual).compareTo(expected) == 0) {
            return this;
        }
        if (Math.abs(expected.floatValue() - ((Float)this.actual).floatValue()) <= deltaValue) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{ErrorMessages.unexpectedNotEqual(this.actual, expected), " using delta:", Formatting.inBrackets(Float.valueOf(deltaValue))}));
    }

    public FloatAssert isNotEqualTo(float other) {
        if (this.compareTo(other) != 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, Float.valueOf(other)));
    }

    public FloatAssert isGreaterThan(float other) {
        if (this.compareTo(other) > 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, Float.valueOf(other)));
    }

    public FloatAssert isLessThan(float other) {
        if (this.compareTo(other) < 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, Float.valueOf(other)));
    }

    public FloatAssert isGreaterThanOrEqualTo(float other) {
        if (this.compareTo(other) >= 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, Float.valueOf(other)));
    }

    public FloatAssert isLessThanOrEqualTo(float other) {
        if (this.compareTo(other) <= 0) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, Float.valueOf(other)));
    }

    private int compareTo(float other) {
        return Float.compare(((Float)this.actual).floatValue(), other);
    }

    public FloatAssert isNaN() {
        return this.isEqualTo(Float.NaN);
    }

    @Override
    public FloatAssert isZero() {
        return this.isEqualTo(0.0f);
    }

    @Override
    public FloatAssert isPositive() {
        return this.isGreaterThan(0.0f);
    }

    @Override
    public FloatAssert isNegative() {
        return this.isLessThan(0.0f);
    }

    @Deprecated
    public static Delta delta(float d) {
        return new Delta(d);
    }

    public FloatAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }

    public FloatAssert satisfies(Condition<Float> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public FloatAssert doesNotSatisfy(Condition<Float> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public FloatAssert is(Condition<Float> condition) {
        this.assertIs(condition);
        return this;
    }

    public FloatAssert isNot(Condition<Float> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public FloatAssert isNotEqualTo(Float other) {
        this.assertNotEqualTo(other);
        return this;
    }

    public FloatAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public FloatAssert isSameAs(Float expected) {
        this.assertSameAs(expected);
        return this;
    }

    public FloatAssert isNotSameAs(Float other) {
        this.assertNotSameAs(other);
        return this;
    }

    @Deprecated
    public static class Delta {
        final float value;

        private Delta(float value) {
            this.value = value;
        }
    }
}

