/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.ArrayInspection;
import org.fest.assertions.Condition;
import org.fest.assertions.Delta;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Formatting;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleArrayAssert
extends ArrayAssert<double[]> {
    protected DoubleArrayAssert(double ... actual) {
        super(actual);
    }

    @Override
    public DoubleArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    @Override
    public DoubleArrayAssert describedAs(String description) {
        return this.as(description);
    }

    @Override
    public DoubleArrayAssert as(Description description) {
        this.description(description);
        return this;
    }

    @Override
    public DoubleArrayAssert describedAs(Description description) {
        return this.as(description);
    }

    public DoubleArrayAssert contains(double ... values) {
        this.assertContains(ArrayInspection.copy(values));
        return this;
    }

    public DoubleArrayAssert containsOnly(double ... values) {
        this.assertContainsOnly(ArrayInspection.copy(values));
        return this;
    }

    public DoubleArrayAssert excludes(double ... values) {
        this.assertExcludes(ArrayInspection.copy(values));
        return this;
    }

    public DoubleArrayAssert satisfies(Condition<double[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public DoubleArrayAssert doesNotSatisfy(Condition<double[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public DoubleArrayAssert is(Condition<double[]> condition) {
        this.assertIs(condition);
        return this;
    }

    public DoubleArrayAssert isNot(Condition<double[]> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public DoubleArrayAssert isNotNull() {
        this.assertNotNull();
        return this;
    }

    public DoubleArrayAssert isNotEmpty() {
        this.assertIsNotEmpty();
        return this;
    }

    public DoubleArrayAssert isEqualTo(double[] expected) {
        if (Arrays.equals((double[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    public DoubleArrayAssert isEqualTo(double[] expected, Delta delta) {
        if (this.actual == expected) {
            return this;
        }
        if (this.actual == null || expected == null) {
            throw this.failureWhenNotEqual(expected, delta);
        }
        int length = expected.length;
        if (((double[])this.actual).length != length) {
            this.failureWhenNotEqual(expected, delta);
        }
        for (int i = 0; i < length; ++i) {
            if (this.equals(expected[i], ((double[])this.actual)[i], delta)) continue;
            this.failureWhenNotEqual(expected, delta);
        }
        return this;
    }

    private AssertionError failureWhenNotEqual(double[] expected, Delta delta) {
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{ErrorMessages.unexpectedNotEqual(this.actual, expected), " using delta:", Formatting.inBrackets(delta.doubleValue())}));
    }

    private boolean equals(double e, double a, Delta delta) {
        if (Double.compare(e, a) == 0) {
            return true;
        }
        return Math.abs(e - a) <= delta.doubleValue();
    }

    public DoubleArrayAssert isNotEqualTo(double[] array) {
        if (!Arrays.equals((double[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }

    public DoubleArrayAssert hasSize(int expected) {
        this.assertHasSize(expected);
        return this;
    }

    public DoubleArrayAssert isSameAs(double[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public DoubleArrayAssert isNotSameAs(double[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }

    @Override
    public DoubleArrayAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

