/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayInspection {
    public static Object[] copy(Object array) {
        List<Object> list = ArrayInspection.toList(array);
        return list == null ? null : list.toArray();
    }

    public static List<Object> toList(Object array) {
        return ArrayInspection.copy(array, new ArrayList());
    }

    public static Set<Object> toSet(Object array) {
        return ArrayInspection.copy(array, new HashSet());
    }

    private static <T extends Collection<Object>> T copy(Object array, T destination) {
        if (array == null) {
            return null;
        }
        int length = ArrayInspection.sizeOf(array);
        for (int i = 0; i < length; ++i) {
            destination.add((Object)Array.get(array, i));
        }
        return destination;
    }

    public static int sizeOf(Object array) {
        if (array == null) {
            throw new NullPointerException("The given array should not be null");
        }
        ArrayInspection.validateIsArray(array);
        return Array.getLength(array);
    }

    private static void validateIsArray(Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("The given object is not an array");
        }
    }

    private ArrayInspection() {
    }
}

