/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.io.File;
import java.nio.charset.Charset;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.internal.Files;
import org.fest.util.VisibleForTesting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAssert
extends AbstractAssert<FileAssert, File> {
    @VisibleForTesting
    Files files = Files.instance();
    @VisibleForTesting
    Charset charset = Charset.defaultCharset();

    protected FileAssert(File actual) {
        super(actual, FileAssert.class);
    }

    public FileAssert exists() {
        this.files.assertExists(this.info, (File)this.actual);
        return this;
    }

    public FileAssert doesNotExist() {
        this.files.assertDoesNotExist(this.info, (File)this.actual);
        return this;
    }

    public FileAssert isFile() {
        this.files.assertIsFile(this.info, (File)this.actual);
        return this;
    }

    public FileAssert isDirectory() {
        this.files.assertIsDirectory(this.info, (File)this.actual);
        return this;
    }

    public FileAssert isAbsolute() {
        this.files.assertIsAbsolute(this.info, (File)this.actual);
        return this;
    }

    public FileAssert isRelative() {
        this.files.assertIsRelative(this.info, (File)this.actual);
        return this;
    }

    public FileAssert hasContentEqualTo(File expected) {
        this.files.assertEqualContent(this.info, (File)this.actual, expected);
        return this;
    }

    public FileAssert hasBinaryContent(byte[] expected) {
        this.files.assertHasBinaryContent(this.info, (File)this.actual, expected);
        return this;
    }

    public FileAssert usingCharset(String charsetName) {
        if (!Charset.isSupported(charsetName)) {
            throw new IllegalArgumentException(String.format("Charset:<'%s'> is not supported on this system", charsetName));
        }
        return this.usingCharset(Charset.forName(charsetName));
    }

    public FileAssert usingCharset(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("The charset should not be null");
        }
        this.charset = charset;
        return this;
    }

    public FileAssert hasContent(String expected) {
        this.files.assertHasContent(this.info, (File)this.actual, expected, this.charset);
        return this;
    }

    public FileAssert canWrite() {
        this.files.assertCanWrite(this.info, (File)this.actual);
        return this;
    }

    public FileAssert canRead() {
        this.files.assertCanRead(this.info, (File)this.actual);
        return this;
    }
}

