/*
 * Decompiled with CFR 0.152.
 */
package org.easyrules.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.easyrules.api.Rule;
import org.easyrules.core.BasicRule;
import org.easyrules.core.RuleProxy;

public class CompositeRule
extends BasicRule {
    protected Set<Rule> rules = new TreeSet<Rule>();
    protected Map<Object, Rule> proxyRules = new HashMap<Object, Rule>();

    public CompositeRule() {
        this("rule", "description", 0x7FFFFFFE);
    }

    public CompositeRule(String name) {
        this(name, "description", 0x7FFFFFFE);
    }

    public CompositeRule(String name, String description) {
        this(name, description, 0x7FFFFFFE);
    }

    public CompositeRule(String name, String description, int priority) {
        super(name, description, priority);
    }

    @Override
    public boolean evaluate() {
        if (!this.rules.isEmpty()) {
            for (Rule rule : this.rules) {
                if (rule.evaluate()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void execute() throws Exception {
        for (Rule rule : this.rules) {
            rule.execute();
        }
    }

    public void addRule(Object rule) {
        Rule proxy = RuleProxy.asRule(rule);
        this.rules.add(proxy);
        this.proxyRules.put(rule, proxy);
    }

    public void removeRule(Object rule) {
        Rule proxy = this.proxyRules.get(rule);
        if (proxy != null) {
            this.rules.remove(proxy);
        }
    }
}

