/*
 * Decompiled with CFR 0.152.
 */
package org.easyrules.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.easyrules.api.Rule;
import org.easyrules.api.RuleListener;
import org.easyrules.api.RulesEngine;
import org.easyrules.core.RuleProxy;
import org.easyrules.core.RulesEngineParameters;
import org.easyrules.core.Utils;

class DefaultRulesEngine
implements RulesEngine {
    private static final Logger LOGGER = Logger.getLogger(RulesEngine.class.getName());
    protected Set<Rule> rules;
    protected RulesEngineParameters parameters;
    private List<RuleListener> ruleListeners;

    DefaultRulesEngine(RulesEngineParameters parameters, List<RuleListener> ruleListeners) {
        this.parameters = parameters;
        this.rules = new TreeSet<Rule>();
        this.ruleListeners = ruleListeners;
        if (parameters.isSilentMode()) {
            Utils.muteLoggers();
        }
    }

    @Override
    public RulesEngineParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void registerRule(Object rule) {
        this.rules.add(RuleProxy.asRule(rule));
    }

    @Override
    public void unregisterRule(Object rule) {
        this.rules.remove(RuleProxy.asRule(rule));
    }

    @Override
    public Set<Rule> getRules() {
        return this.rules;
    }

    @Override
    public List<RuleListener> getRuleListeners() {
        return this.ruleListeners;
    }

    @Override
    public void clearRules() {
        this.rules.clear();
        LOGGER.info("Rules cleared.");
    }

    @Override
    public void fireRules() {
        if (this.rules.isEmpty()) {
            LOGGER.warning("No rules registered! Nothing to apply");
            return;
        }
        this.logEngineParameters();
        this.sortRules();
        this.logRegisteredRules();
        this.applyRules();
    }

    @Override
    public Map<Rule, Boolean> checkRules() {
        LOGGER.info("Checking rules");
        this.sortRules();
        HashMap<Rule, Boolean> result = new HashMap<Rule, Boolean>();
        for (Rule rule : this.rules) {
            if (!this.shouldBeEvaluated(rule)) continue;
            result.put(rule, rule.evaluate());
        }
        return result;
    }

    private void sortRules() {
        this.rules = new TreeSet<Rule>(this.rules);
    }

    private void applyRules() {
        LOGGER.info("Rules evaluation started");
        for (Rule rule : this.rules) {
            String name = rule.getName();
            int priority = rule.getPriority();
            if (priority > this.parameters.getPriorityThreshold()) {
                LOGGER.log(Level.INFO, "Rule priority threshold ({0}) exceeded at rule ''{1}'' with priority={2}, next rules will be skipped", new Object[]{this.parameters.getPriorityThreshold(), name, priority});
                break;
            }
            if (!this.shouldBeEvaluated(rule)) {
                LOGGER.log(Level.INFO, "Rule ''{0}'' has been skipped before being evaluated", name);
                continue;
            }
            if (rule.evaluate()) {
                LOGGER.log(Level.INFO, "Rule ''{0}'' triggered", name);
                try {
                    this.triggerListenersBeforeExecute(rule);
                    rule.execute();
                    LOGGER.log(Level.INFO, "Rule ''{0}'' performed successfully", name);
                    this.triggerListenersOnSuccess(rule);
                    if (!this.parameters.isSkipOnFirstAppliedRule()) continue;
                    LOGGER.info("Next rules will be skipped since parameter skipOnFirstAppliedRule is set");
                }
                catch (Exception exception) {
                    LOGGER.log(Level.SEVERE, String.format("Rule '%s' performed with error", name), exception);
                    this.triggerListenersOnFailure(rule, exception);
                    if (!this.parameters.isSkipOnFirstFailedRule()) continue;
                    LOGGER.info("Next rules will be skipped since parameter skipOnFirstFailedRule is set");
                }
                break;
            }
            LOGGER.log(Level.INFO, "Rule ''{0}'' has been evaluated to false, it has not been executed", name);
            if (!this.parameters.isSkipOnFirstNonTriggeredRule()) continue;
            LOGGER.info("Next rules will be skipped since parameter skipOnFirstNonTriggeredRule is set");
            break;
        }
    }

    private void triggerListenersOnFailure(Rule rule, Exception exception) {
        for (RuleListener ruleListener : this.ruleListeners) {
            ruleListener.onFailure(rule, exception);
        }
    }

    private void triggerListenersOnSuccess(Rule rule) {
        for (RuleListener ruleListener : this.ruleListeners) {
            ruleListener.onSuccess(rule);
        }
    }

    private void triggerListenersBeforeExecute(Rule rule) {
        for (RuleListener ruleListener : this.ruleListeners) {
            ruleListener.beforeExecute(rule);
        }
    }

    private boolean triggerListenersBeforeEvaluate(Rule rule) {
        for (RuleListener ruleListener : this.ruleListeners) {
            if (ruleListener.beforeEvaluate(rule)) continue;
            return false;
        }
        return true;
    }

    private boolean shouldBeEvaluated(Rule rule) {
        return this.triggerListenersBeforeEvaluate(rule);
    }

    private void logEngineParameters() {
        LOGGER.log(Level.INFO, "Engine name: {0}", this.parameters.getName());
        LOGGER.log(Level.INFO, "Rule priority threshold: {0}", this.parameters.getPriorityThreshold());
        LOGGER.log(Level.INFO, "Skip on first applied rule: {0}", this.parameters.isSkipOnFirstAppliedRule());
        LOGGER.log(Level.INFO, "Skip on first non triggered rule: {0}", this.parameters.isSkipOnFirstNonTriggeredRule());
        LOGGER.log(Level.INFO, "Skip on first failed rule: {0}", this.parameters.isSkipOnFirstFailedRule());
    }

    private void logRegisteredRules() {
        LOGGER.log(Level.INFO, "Registered rules:");
        for (Rule rule : this.rules) {
            LOGGER.log(Level.INFO, String.format("Rule { name = '%s', description = '%s', priority = '%s'}", rule.getName(), rule.getDescription(), rule.getPriority()));
        }
    }

    public String toString() {
        return this.parameters.getName();
    }
}

