/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.jpa;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.drools.core.SessionConfiguration;
import org.drools.core.command.CommandService;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.process.instance.WorkItemManagerFactory;
import org.drools.persistence.SingleSessionCommandService;
import org.drools.persistence.jpa.processinstance.JPAWorkItemManagerFactory;
import org.kie.api.KieBase;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.TimerJobFactoryOption;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class KnowledgeStoreServiceImpl
implements KieStoreServices {
    private Class<? extends CommandExecutor> commandServiceClass;
    private Class<? extends WorkItemManagerFactory> workItemManagerFactoryClass;
    private Properties configProps = new Properties();

    public KnowledgeStoreServiceImpl() {
        this.setDefaultImplementations();
    }

    protected void setDefaultImplementations() {
        this.setCommandServiceClass(SingleSessionCommandService.class);
        this.setProcessInstanceManagerFactoryClass("org.jbpm.persistence.processinstance.JPAProcessInstanceManagerFactory");
        this.setWorkItemManagerFactoryClass(JPAWorkItemManagerFactory.class);
        this.setProcessSignalManagerFactoryClass("org.jbpm.persistence.processinstance.JPASignalManagerFactory");
    }

    public StatefulKnowledgeSession newKieSession(KieBase kbase, KieSessionConfiguration configuration, Environment environment) {
        if (configuration == null) {
            configuration = new SessionConfiguration();
        }
        if (environment == null) {
            throw new IllegalArgumentException("Environment cannot be null");
        }
        return new CommandBasedStatefulKnowledgeSession((CommandService)this.buildCommandService(kbase, this.mergeConfig(configuration), environment));
    }

    public StatefulKnowledgeSession loadKieSession(int id, KieBase kbase, KieSessionConfiguration configuration, Environment environment) {
        if (configuration == null) {
            configuration = new SessionConfiguration();
        }
        if (environment == null) {
            throw new IllegalArgumentException("Environment cannot be null");
        }
        return new CommandBasedStatefulKnowledgeSession((CommandService)this.buildCommandService(id, kbase, this.mergeConfig(configuration), environment));
    }

    private CommandExecutor buildCommandService(Integer sessionId, KieBase kbase, KieSessionConfiguration conf, Environment env) {
        try {
            Class<? extends CommandExecutor> serviceClass = this.getCommandServiceClass();
            Constructor<? extends CommandExecutor> constructor = serviceClass.getConstructor(Integer.class, KieBase.class, KieSessionConfiguration.class, Environment.class);
            return constructor.newInstance(sessionId, kbase, conf, env);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private CommandExecutor buildCommandService(KieBase kbase, KieSessionConfiguration conf, Environment env) {
        Class<? extends CommandExecutor> serviceClass = this.getCommandServiceClass();
        try {
            Constructor<? extends CommandExecutor> constructor = serviceClass.getConstructor(KieBase.class, KieSessionConfiguration.class, Environment.class);
            return constructor.newInstance(kbase, conf, env);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private KieSessionConfiguration mergeConfig(KieSessionConfiguration configuration) {
        ((SessionConfiguration)configuration).addDefaultProperties(this.configProps);
        configuration.setOption((KieSessionOption)TimerJobFactoryOption.get((String)"jpa"));
        return configuration;
    }

    public long getStatefulKnowledgeSessionId(StatefulKnowledgeSession ksession) {
        if (ksession instanceof CommandBasedStatefulKnowledgeSession) {
            SingleSessionCommandService commandService = (SingleSessionCommandService)((CommandBasedStatefulKnowledgeSession)ksession).getCommandService();
            return commandService.getSessionId();
        }
        throw new IllegalArgumentException("StatefulKnowledgeSession must be an a CommandBasedStatefulKnowledgeSession");
    }

    public void setCommandServiceClass(Class<? extends CommandExecutor> commandServiceClass) {
        if (commandServiceClass != null) {
            this.commandServiceClass = commandServiceClass;
            this.configProps.put("drools.commandService", commandServiceClass.getName());
        }
    }

    public Class<? extends CommandExecutor> getCommandServiceClass() {
        return this.commandServiceClass;
    }

    public void setProcessInstanceManagerFactoryClass(String processInstanceManagerFactoryClass) {
        this.configProps.put("drools.processInstanceManagerFactory", processInstanceManagerFactoryClass);
    }

    public void setWorkItemManagerFactoryClass(Class<? extends WorkItemManagerFactory> workItemManagerFactoryClass) {
        if (workItemManagerFactoryClass != null) {
            this.workItemManagerFactoryClass = workItemManagerFactoryClass;
            this.configProps.put("drools.workItemManagerFactory", workItemManagerFactoryClass.getName());
        }
    }

    public Class<? extends WorkItemManagerFactory> getWorkItemManagerFactoryClass() {
        return this.workItemManagerFactoryClass;
    }

    public void setProcessSignalManagerFactoryClass(String processSignalManagerFactoryClass) {
        this.configProps.put("drools.processSignalManagerFactory", processSignalManagerFactoryClass);
    }
}

