/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.divxdede.swing.RemainingTimeMonitor;
import org.divxdede.swing.busy.BusyIcon;
import org.divxdede.swing.busy.BusyModel;
import org.divxdede.swing.busy.icon.InfiniteBusyIcon;
import org.divxdede.swing.busy.ui.AbstractBusyLayerUI;
import org.divxdede.text.TimeFormat;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.painter.BusyPainter;
import org.jdesktop.swingx.painter.MattePainter;
import org.jdesktop.swingx.painter.Painter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicBusyLayerUI
extends AbstractBusyLayerUI {
    JXPanel jXGlassPane = new JXPanel();
    JLabel jLabel = new JLabel();
    JProgressBar jProgressBar = new JProgressBar();
    JXHyperlink jXHyperlinkCancel = new JXHyperlink();
    BusyIcon busyIcon = null;
    Observer observer = new AnimationObserver();
    boolean remainingTimeVisible = false;
    RemainingTimeMonitor monitor = null;
    final TimeFormat timeFormat = new TimeFormat(TimeUnit.SECONDS);
    int millisToDecideToPopup = 300;
    int millisToPopup = 1200;
    ActionListener cancelListener = null;
    float veilAlpha = 0.0f;
    Color veilColor = null;
    long backgroundVeilStartTime = 0L;
    int shadeDelayTotal = 0;
    private int alpha = 0;
    private Timer timer = null;
    private Painter painter = null;
    private AtomicBoolean repainted = new AtomicBoolean(false);
    private static final Border NO_SPACE = new EmptyBorder(new Insets(0, 0, 0, 0));
    private static final Border MARGIN = new EmptyBorder(new Insets(0, 10, 0, 0));
    private static final int REFRESH_DELAI = 32;

    public BasicBusyLayerUI() {
        this(400, 0.85f, Color.WHITE);
    }

    public BasicBusyLayerUI(int shadeDelay, float veilAlpha, Color veilColor) {
        this.cancelListener = this.createCancelListener();
        this.timer = this.createTimer();
        this.createGlassPane();
        this.shadeDelayTotal = shadeDelay;
        this.veilAlpha = veilAlpha;
        this.veilColor = veilColor;
        this.setBusyIcon(new InfiniteBusyIcon());
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        JXLayer layer = (JXLayer)c;
        layer.setGlassPane((JPanel)this.jXGlassPane);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        JXLayer layer = (JXLayer)c;
        layer.setGlassPane(null);
    }

    @Override
    public void setBusyIcon(BusyIcon icon) {
        if (this.busyIcon != null && this.busyIcon instanceof Observable) {
            ((Observable)((Object)this.busyIcon)).deleteObserver(this.observer);
        }
        if (this.busyIcon != null) {
            this.busyIcon.setModel(null);
        }
        this.busyIcon = icon;
        if (this.busyIcon != null && this.busyIcon instanceof Observable) {
            ((Observable)((Object)this.busyIcon)).addObserver(this.observer);
        }
        if (this.busyIcon != null) {
            this.busyIcon.setModel(this.getBusyModel());
        }
        this.jLabel.setIcon(this.busyIcon);
        this.updateUI();
    }

    @Override
    public BusyIcon getBusyIcon() {
        return this.busyIcon;
    }

    public void setMillisToDecideToPopup(int millisToDecideToPopup) {
        this.millisToDecideToPopup = millisToDecideToPopup;
    }

    public int getMillisToDecideToPopup() {
        return this.millisToDecideToPopup;
    }

    public void setMillisToPopup(int millisToPopup) {
        this.millisToPopup = millisToPopup;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setRemainingTimeVisible(boolean value) {
        this.remainingTimeVisible = value;
    }

    public boolean isRemainingTimeVisible() {
        return this.remainingTimeVisible;
    }

    public BusyPainter getBusyPainter() {
        BusyIcon myIcon = this.getBusyIcon();
        if (myIcon instanceof InfiniteBusyIcon) {
            return ((InfiniteBusyIcon)myIcon).getBusyPainter();
        }
        return null;
    }

    public void setBusyPainter(BusyPainter busyPainter) {
        this.setBusyPainter(busyPainter, null);
    }

    public void setBusyPainter(BusyPainter busyPainter, Dimension preferredSize) {
        this.setBusyIcon(new InfiniteBusyIcon(busyPainter, preferredSize));
    }

    protected void paintLayer(Graphics2D g2, JXLayer<? extends JComponent> l) {
        super.paintLayer(g2, l);
        Painter painter = this.getBackGroundPainter();
        if (painter != null) {
            painter.paint(g2, null, l.getWidth(), l.getHeight());
        }
    }

    @Override
    protected void updateUIImpl() {
        boolean hyperlinkVisible;
        BusyModel myModel = this.getBusyModel();
        BusyIcon myIcon = this.getBusyIcon();
        boolean isBusy = this.isComponentBusy();
        if (myModel != null && myModel.isBusy() && !this.timer.isRunning()) {
            this.timer.start();
        }
        this.repainted.set(true);
        this.jXGlassPane.setVisible(isBusy);
        this.jLabel.setVisible(isBusy);
        this.jProgressBar.setVisible(isBusy && myModel.isDeterminate() && !myIcon.isDeterminate());
        boolean bl = hyperlinkVisible = isBusy && myModel.isCancellable();
        if (hyperlinkVisible && !this.jXHyperlinkCancel.isVisible()) {
            this.jXHyperlinkCancel.setClicked(false);
        }
        this.jXHyperlinkCancel.setVisible(hyperlinkVisible);
        this.manageBackgroundVeil(isBusy);
        if (isBusy) {
            if (myModel.isCancellable()) {
                this.jXHyperlinkCancel.setBorder(this.jProgressBar.isVisible() ? MARGIN : NO_SPACE);
            }
            String description = myModel.getDescription();
            String remaining = this.getRemainingTimeString();
            if (this.isRemainingTimeVisible()) {
                if (remaining == null) {
                    remaining = " ";
                }
                if (description == null) {
                    this.jLabel.setText(remaining);
                    this.jProgressBar.setString(null);
                    this.jProgressBar.setStringPainted(true);
                } else {
                    this.jLabel.setText(description);
                    this.jProgressBar.setString(remaining);
                    this.jProgressBar.setStringPainted(true);
                }
            } else if (description == null) {
                this.jLabel.setText(this.getPercentProgressionString());
                this.jProgressBar.setStringPainted(false);
                this.jProgressBar.setString(null);
            } else {
                this.jLabel.setText(description);
                this.jProgressBar.setString(this.getPercentProgressionString());
                this.jProgressBar.setStringPainted(true);
            }
        }
        super.updateUIImpl();
    }

    @Override
    public void setBusyModel(BusyModel model) {
        super.setBusyModel(model);
        if (this.getBusyModel() != null) {
            this.jProgressBar.setModel(model);
            if (this.busyIcon != null) {
                this.busyIcon.setModel(this.getBusyModel());
            }
        }
    }

    private JComponent createGlassPane() {
        GridBagLayout layout = new GridBagLayout();
        this.jXGlassPane.setLayout((LayoutManager)layout);
        this.jXGlassPane.setOpaque(false);
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        GridBagConstraints gbcLabel = new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 0, emptyInsets, 0, 0);
        GridBagConstraints gbcBar = new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, emptyInsets, 0, 0);
        GridBagConstraints gbcLink = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, emptyInsets, 0, 0);
        this.jXGlassPane.add((Component)this.jLabel, (Object)gbcLabel);
        this.jXGlassPane.add((Component)this.jProgressBar, (Object)gbcBar);
        this.jXGlassPane.add((Component)this.jXHyperlinkCancel, (Object)gbcLink);
        this.jLabel.setHorizontalAlignment(0);
        this.jLabel.setHorizontalTextPosition(0);
        this.jLabel.setVerticalTextPosition(3);
        this.jXHyperlinkCancel.setText(UIManager.getString("OptionPane.cancelButtonText"));
        this.jXHyperlinkCancel.addActionListener(this.cancelListener);
        this.updateUI();
        return this.jXGlassPane;
    }

    private String getPercentProgressionString() {
        BusyModel myModel = this.getBusyModel();
        boolean isBusy = this.isModelBusy();
        if (!isBusy) {
            return null;
        }
        if (!myModel.isDeterminate()) {
            return null;
        }
        int range = myModel.getMaximum() - myModel.getMinimum();
        int value = myModel.getValue();
        float percent = 100.0f / (float)range * (float)(value - myModel.getMinimum());
        return Integer.toString((int)percent) + " %";
    }

    private String getRemainingTimeString() {
        long timeRemaining;
        if (!this.isRemainingTimeVisible()) {
            return null;
        }
        BusyModel myModel = this.getBusyModel();
        if (!myModel.isDeterminate()) {
            return null;
        }
        if (this.monitor != null && (timeRemaining = this.monitor.getRemainingTime(TimeUnit.SECONDS)) > 0L) {
            return " Remaining time: " + this.timeFormat.format((Object)timeRemaining);
        }
        return null;
    }

    private ActionListener createCancelListener() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    BasicBusyLayerUI.this.getBusyModel().cancel();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        };
    }

    protected boolean isComponentBusy() {
        boolean triggerEnabled;
        boolean isModelBusy = this.isModelBusy();
        boolean isDeterminate = isModelBusy && this.getBusyModel().isDeterminate();
        boolean bl = triggerEnabled = this.getMillisToDecideToPopup() > 0 && this.getMillisToPopup() > 0;
        if (isModelBusy) {
            if (this.monitor == null && isDeterminate && (triggerEnabled || this.isRemainingTimeVisible())) {
                int decideTime = this.getMillisToDecideToPopup() > 0 ? this.getMillisToDecideToPopup() : 500;
                this.monitor = new RemainingTimeMonitor(this.getBusyModel(), decideTime, 10);
            }
            if (triggerEnabled && isDeterminate) {
                long remainingTime = this.monitor.getRemainingTime();
                if (remainingTime == -1L) {
                    return false;
                }
                if (this.monitor.getRemainingTime() < (long)this.getMillisToPopup()) {
                    return this.jXGlassPane.isVisible();
                }
            }
        } else if (this.monitor != null) {
            this.monitor.dispose();
            this.monitor = null;
        }
        return isModelBusy;
    }

    @Override
    protected boolean shouldLock() {
        return this.isModelBusy() || this.isBackgroundPainterDirty(this.isComponentBusy());
    }

    private synchronized Painter getBackGroundPainter() {
        return this.painter;
    }

    protected Painter createBackgroundPainter(int alpha) {
        return new MattePainter((Paint)new Color(this.veilColor.getRed(), this.veilColor.getGreen(), this.veilColor.getBlue(), alpha));
    }

    private synchronized void manageBackgroundVeil(boolean isBusy) {
        if (!this.isBackgroundPainterDirty(isBusy)) {
            return;
        }
        if (this.shadeDelayTotal <= 0) {
            this.updateBackgroundPainter(isBusy);
        }
    }

    private synchronized Timer createTimer() {
        ActionListener actionListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                BasicBusyLayerUI basicBusyLayerUI = BasicBusyLayerUI.this;
                synchronized (basicBusyLayerUI) {
                    boolean isBusy = BasicBusyLayerUI.this.isComponentBusy();
                    if (BasicBusyLayerUI.this.updateBackgroundPainter(isBusy)) {
                        BasicBusyLayerUI.this.updateUI();
                    } else if (!BasicBusyLayerUI.this.repainted.get()) {
                        BasicBusyLayerUI.this.updateUI();
                        BasicBusyLayerUI.this.repainted.set(false);
                    }
                    if (!BasicBusyLayerUI.this.isModelBusy() && !BasicBusyLayerUI.this.isBackgroundPainterDirty(isBusy)) {
                        ((Timer)e.getSource()).stop();
                    }
                }
            }
        };
        return new Timer(32, actionListener);
    }

    private synchronized boolean isBackgroundPainterDirty(boolean isBusy) {
        if (this.veilColor == null || this.veilAlpha == 0.0f) {
            return false;
        }
        if (isBusy && this.alpha < 255) {
            return true;
        }
        return !isBusy && this.alpha > 0;
    }

    private synchronized boolean updateBackgroundPainter(boolean isBusy) {
        Painter oldPainter = this.painter;
        if (isBusy && (this.alpha < 255 || this.painter == null)) {
            if (this.backgroundVeilStartTime <= 0L) {
                this.backgroundVeilStartTime = System.currentTimeMillis();
            }
            long delay = System.currentTimeMillis() - this.backgroundVeilStartTime;
            double veilRatio = (double)delay / (double)this.shadeDelayTotal;
            if (this.shadeDelayTotal <= 0) {
                this.alpha = 255;
                this.backgroundVeilStartTime = 0L;
            } else {
                this.alpha = (int)(255.0 * veilRatio);
                if (this.alpha >= 255) {
                    this.alpha = 255;
                    this.backgroundVeilStartTime = 0L;
                }
            }
            this.painter = this.createBackgroundPainter((int)((float)this.alpha * this.veilAlpha));
        } else if (!(isBusy || this.alpha <= 0 && this.painter == null)) {
            if (this.backgroundVeilStartTime >= 0L) {
                this.backgroundVeilStartTime = -System.currentTimeMillis();
            }
            long delay = System.currentTimeMillis() + this.backgroundVeilStartTime;
            double veilRatio = (double)delay / (double)this.shadeDelayTotal;
            if (this.shadeDelayTotal <= 0) {
                this.alpha = 0;
                this.backgroundVeilStartTime = 0L;
            } else {
                this.alpha = 255 - (int)(255.0 * veilRatio);
            }
            if (this.alpha > 0) {
                this.painter = this.createBackgroundPainter((int)((float)this.alpha * this.veilAlpha));
            } else {
                this.alpha = 0;
                this.painter = null;
                this.backgroundVeilStartTime = 0L;
            }
        } else {
            this.backgroundVeilStartTime = 0L;
        }
        return oldPainter != this.painter;
    }

    private class AnimationObserver
    implements Observer {
        private AnimationObserver() {
        }

        public void update(Observable o, Object arg) {
            BasicBusyLayerUI.this.updateUI();
        }
    }
}

