/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy.ui;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.divxdede.swing.busy.BusyModel;
import org.divxdede.swing.busy.ui.BusyLayerUI;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.ext.LockableUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBusyLayerUI
extends LockableUI
implements BusyLayerUI {
    private BusyModel model = null;
    private ChangeListener modelListener = null;
    private AtomicBoolean lastBusyState = new AtomicBoolean(false);

    public AbstractBusyLayerUI() {
        this.modelListener = this.createModelListener();
    }

    @Override
    public void setBusyModel(BusyModel model) {
        BusyModel oldValue = this.getBusyModel();
        if (this.getBusyModel() != null) {
            this.getBusyModel().removeChangeListener(this.modelListener);
        }
        this.model = model;
        if (this.getBusyModel() != null) {
            this.lastBusyState.set(this.model.isBusy());
            this.getBusyModel().addChangeListener(this.modelListener);
            this.updateUI();
        }
    }

    @Override
    public BusyModel getBusyModel() {
        return this.model;
    }

    protected final void updateUI() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateUIImpl();
        } else {
            Runnable doRun = new Runnable(){

                public void run() {
                    AbstractBusyLayerUI.this.updateUIImpl();
                }
            };
            SwingUtilities.invokeLater(doRun);
        }
    }

    public void updateUI(JXLayer<? extends JComponent> l) {
        this.updateUI();
        super.updateUI(l);
    }

    protected void updateUIImpl() {
        this.setLocked(this.shouldLock());
        this.setDirty(true);
    }

    protected boolean isModelBusy() {
        return this.getBusyModel() == null ? false : this.getBusyModel().isBusy();
    }

    protected boolean shouldLock() {
        return this.isModelBusy();
    }

    private ChangeListener createModelListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                boolean newValue = AbstractBusyLayerUI.this.getBusyModel().isBusy();
                if (AbstractBusyLayerUI.this.lastBusyState.get() != newValue) {
                    AbstractBusyLayerUI.this.lastBusyState.set(newValue);
                    AbstractBusyLayerUI.this.updateUI();
                }
            }
        };
    }
}

