/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy.icon;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import javax.swing.Icon;
import org.divxdede.swing.ColorUtilities;
import org.divxdede.swing.busy.icon.DecoratorBusyIcon;

public class RadialBusyIcon
extends DecoratorBusyIcon {
    private static final int DETERMINATE_ARC_LENGTH = 45;
    private static final int DETERMINATE_RADIAL_INSETS = 4;
    private static final int UNDETERMINATE_ADVANCE_LENGTH = 60;
    private static final int UNDETERMINATE_ARC_LENGTH = 360;
    private static final int UNDETERMINATE_RADIAL_INSETS = 0;
    private Paint barBackground = null;
    private Paint barForeground = null;
    private int diameter = 0;
    private int thickness = 0;
    private int delay = 1000;

    public RadialBusyIcon(Icon baseIcon) {
        this(baseIcon, new Insets(7, 7, 7, 7));
    }

    public RadialBusyIcon(Icon baseIcon, Insets insets) {
        super(baseIcon, insets);
        this.setDelay(1500);
        this.installDefaults();
    }

    protected final void paintUndeterminate(Component c, Graphics g, int x, int y, int frame) {
        float start = (float)frame / 36.0f;
        float end = start + 0.16666667f;
        this.paintImpl(c, g, x, y, false, start, end);
    }

    protected final void paintDeterminate(Component c, Graphics g, int x, int y, float ratio) {
        this.paintImpl(c, g, x, y, true, 0.0f, ratio);
    }

    protected void paintProgressBar(Component c, Graphics g, boolean determinate) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int arc_length = 45;
        int insets = 4;
        if (!determinate) {
            arc_length = 360;
            insets = 0;
        }
        int upperLeftX = (this.getIconWidth() - this.getProgressBarDiameter()) / 2;
        int upperLeftY = (this.getIconHeight() - this.getProgressBarDiameter()) / 2;
        g2d.setPaint(this.getProgressBarBackground());
        for (int i = insets; i < 360; i += arc_length) {
            int start = i;
            int angle = arc_length - insets * 2;
            g2d.fillArc(upperLeftX, upperLeftY, this.getProgressBarDiameter(), this.getProgressBarDiameter(), RadialBusyIcon.translateAngle(start), angle * -1);
        }
        g2d.setComposite(AlphaComposite.Clear);
        int holeDiameter = this.getProgressBarDiameter() - this.getProgressBarThickness();
        upperLeftX = (this.getIconWidth() - holeDiameter) / 2;
        upperLeftY = (this.getIconHeight() - holeDiameter) / 2;
        g2d.fillOval(upperLeftX, upperLeftY, holeDiameter, holeDiameter);
        g2d.setPaintMode();
    }

    protected void paintProgressBarAdvance(Component c, Graphics g, boolean determinate, float start, float end) {
        int arc_length = 45;
        int insets = 4;
        if (!determinate) {
            arc_length = 360;
            insets = 0;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setPaint(this.getProgressBarForeground());
        int upperLeftX = (this.getIconWidth() - this.getProgressBarDiameter()) / 2;
        int upperLeftY = (this.getIconHeight() - this.getProgressBarDiameter()) / 2;
        int startAngle = Math.round(start * 360.0f);
        int endAngle = Math.round(end * 360.0f);
        boolean started = false;
        for (int i = insets; i < 360 + arc_length; i += arc_length) {
            int myArcLength = arc_length - insets * 2;
            int myArcStart = i;
            int myArcEnd = myArcStart + myArcLength;
            if (!started) {
                if (i - insets > startAngle || startAngle >= myArcEnd) continue;
                started = true;
            }
            if (endAngle < myArcStart) break;
            myArcStart = Math.max(startAngle, myArcStart);
            myArcEnd = Math.min(endAngle, myArcEnd);
            g2d.fillArc(upperLeftX, upperLeftY, this.getProgressBarDiameter(), this.getProgressBarDiameter(), RadialBusyIcon.translateAngle(myArcStart), (myArcEnd - myArcStart) * -1);
        }
        g2d.setComposite(AlphaComposite.Clear);
        int holeDiameter = this.getProgressBarDiameter() - this.getProgressBarThickness();
        upperLeftX = (this.getIconWidth() - holeDiameter) / 2;
        upperLeftY = (this.getIconHeight() - holeDiameter) / 2;
        g2d.fillOval(upperLeftX, upperLeftY, holeDiameter, holeDiameter);
        g2d.setPaintMode();
    }

    protected float getSignificantRatioOffset() {
        return 0.0027777778f;
    }

    public void setDelay(int delay) {
        this.setUndeterminateFrameRate(Math.round((float)delay / 36.0f), 36);
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    protected void setProgressBarDiameter(int diameter) {
        int old = this.getProgressBarDiameter();
        this.diameter = diameter;
        if (old != this.getProgressBarDiameter()) {
            this.repaint(true);
        }
    }

    protected int getProgressBarDiameter() {
        return this.diameter;
    }

    protected void setProgressBarThickness(int thickness) {
        int old = this.getProgressBarThickness();
        this.thickness = thickness;
        if (old != this.getProgressBarThickness()) {
            this.repaint(true);
        }
    }

    protected int getProgressBarThickness() {
        return this.thickness;
    }

    public void setProgressBarBackground(Paint background) {
        Paint old = this.barBackground;
        this.barBackground = background;
        if (old != this.barBackground) {
            this.repaint(true);
        }
    }

    public Paint getProgressBarBackground() {
        return this.barBackground;
    }

    public void setProgressBarForeground(Paint foreground) {
        Paint old = this.barForeground;
        this.barForeground = foreground;
        if (old != this.barForeground) {
            this.repaint(true);
        }
    }

    public Paint getProgressBarForeground() {
        return this.barForeground;
    }

    protected void installDefaults() {
        int diameter = Math.min(this.getIconWidth(), this.getIconHeight());
        int thick = Math.round((float)diameter * 0.5f);
        this.setProgressBarDiameter(diameter);
        this.setProgressBarThickness(thick);
        this.setProgressBarBackground(this.createPaintUI(Color.GRAY, true));
        this.setProgressBarForeground(this.createPaintUI(new Color(117, 205, 78), true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintImpl(Component c, Graphics g, int x, int y, boolean determinate, float start, float end) {
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            g2d.translate(x, y);
            this.paintProgressBar(c, g, determinate);
        }
        finally {
            g2d.dispose();
        }
        g2d = (Graphics2D)g.create();
        try {
            g2d.translate(x, y);
            this.paintProgressBarAdvance(c, g, determinate, start, end);
        }
        finally {
            g2d.dispose();
        }
        g2d = (Graphics2D)g.create();
        try {
            this.paintDecoratedIcon(c, g, x, y);
        }
        finally {
            g2d.dispose();
        }
    }

    private static int translateAngle(int degree) {
        return (degree - 90) * -1;
    }

    private Paint createPaintUI(Color color, boolean withShading) {
        if (withShading) {
            int barDiameter = this.getProgressBarDiameter();
            int holeDiameter = this.getProgressBarDiameter() - this.getProgressBarThickness();
            float holeFraction = (float)holeDiameter / (float)barDiameter;
            int xBar = (this.getIconWidth() - barDiameter) / 2 + barDiameter / 2;
            int yBar = (this.getIconHeight() - barDiameter) / 2 + barDiameter / 2;
            Color colorA = ColorUtilities.brighter((Color)color, (float)0.4f);
            Color colorB = color;
            return new RadialGradientPaint(xBar, (float)yBar, Math.round((float)barDiameter / 2.0f), new float[]{holeFraction, 1.0f}, new Color[]{colorA, colorB});
        }
        return color;
    }
}

