/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy.icon;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.UIManager;
import org.divxdede.swing.busy.icon.AbstractBusyIcon;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.painter.BusyPainter;

public class InfiniteBusyIcon
extends AbstractBusyIcon {
    private BusyPainter painter = null;
    private int frame = 0;
    private Dimension dimension = null;
    private int delay = -1;

    public InfiniteBusyIcon() {
        this(null, null);
    }

    public InfiniteBusyIcon(Dimension dim) {
        this(null, dim);
    }

    public InfiniteBusyIcon(BusyPainter painter, Dimension dim) {
        if (painter == null) {
            painter = new BusyPainter();
        }
        if (dim == null) {
            dim = new Dimension(26, 26);
        }
        this.dimension = dim;
        this.setBusyPainter(painter);
    }

    protected void paintIdle(Component c, Graphics g, int x, int y) {
        this.paintBackground(c, g, x, y);
    }

    protected void paintDeterminate(Component c, Graphics g, int x, int y, float ratio) {
        this.paintIdle(c, g, x, y);
    }

    protected void paintUndeterminate(Component c, Graphics g, int x, int y, int frame) {
        this.paintBackground(c, g, x, y);
        if (this.getBusyPainter() != null) {
            this.getBusyPainter().setFrame(frame);
        }
        this.paintInfiniteSpinner(c, g, x, y);
    }

    protected void paintBackground(Component c, Graphics g, int x, int y) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintInfiniteSpinner(Component c, Graphics g, int x, int y) {
        BusyPainter painter = this.getBusyPainter();
        if (painter != null) {
            Graphics2D g2d = (Graphics2D)g.create();
            try {
                g2d.translate(x, y);
                painter.paint(g2d, null, this.getIconWidth(), this.getIconHeight());
            }
            finally {
                g2d.dispose();
            }
        }
    }

    public boolean isDeterminate() {
        return false;
    }

    public void setDelay(int delay) {
        BusyPainter painter = this.getBusyPainter();
        this.delay = delay;
        if (painter != null) {
            this.setUndeterminateFrameRate(this.getDelay(), painter.getPoints());
        } else {
            this.setUndeterminateFrameRate(0, 0);
        }
    }

    public int getDelay() {
        if (this.delay == -1) {
            return UIManager.getInt("JXBusyLabel.delay");
        }
        return this.delay;
    }

    public void setBusyPainter(BusyPainter painter) {
        this.painter = painter;
        this.frame = 0;
        if (this.painter != null) {
            this.setUndeterminateFrameRate(this.getDelay(), painter.getPoints());
        } else {
            this.setUndeterminateFrameRate(0, 0);
        }
        this.repaint(true);
    }

    public BusyPainter getBusyPainter() {
        return this.painter;
    }

    public int getIconWidth() {
        return (int)this.dimension.getWidth();
    }

    public int getIconHeight() {
        return (int)this.dimension.getHeight();
    }

    protected float getSignificantRatioOffset() {
        return 0.01f;
    }

    static {
        new JXBusyLabel();
    }
}

