/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.divxdede.swing.ColorUtilities;
import org.divxdede.swing.busy.icon.DecoratorBusyIcon;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.painter.RectanglePainter;

public class DefaultBusyIcon
extends DecoratorBusyIcon {
    private static final int FRAMES = 20;
    private static final float FRAME_STEP_RATIO = 0.05f;
    private static final int FRAME_EXTENDS = Math.round(6.6000004f);
    private boolean backgroundPainted = true;
    private Painter backgroundPainter = null;
    private Paint barBackground = null;
    private Paint barForeground = null;
    private Rectangle barBounds = new Rectangle(0, 0, 10, 10);
    private int delay = 1000;

    public DefaultBusyIcon(Icon baseIcon) {
        this(baseIcon, (Insets)null);
    }

    public DefaultBusyIcon(Icon baseIcon, Insets insets) {
        this(baseIcon, (Painter)null, insets);
    }

    public DefaultBusyIcon(Icon baseIcon, Color backgroundColor) {
        this(baseIcon, (Painter)null, null);
    }

    public DefaultBusyIcon(Icon baseIcon, Color backgroundColor, Insets insets) {
        this(baseIcon, (Painter)null, insets);
        if (backgroundColor != null) {
            this.installDefaultBackgroundPainter(backgroundColor);
        }
    }

    public DefaultBusyIcon(Icon baseIcon, Painter backgroundPainter) {
        this(baseIcon, backgroundPainter, null);
    }

    public DefaultBusyIcon(Icon baseIcon, Painter backgroundPainter, Insets insets) {
        super(baseIcon, insets == null ? new Insets(4, 4, 4, 4) : insets);
        this.setDelay(500);
        this.installDefaultProgressBarBounds();
        if (backgroundPainter != null) {
            this.setBackgroundPainter(backgroundPainter);
        } else {
            this.installDefaultBackgroundPainter(Color.BLACK);
        }
        this.installDefaultProgressBarColors();
    }

    protected final void paintUndeterminate(Component c, Graphics g, int x, int y, int frame) {
        int forewardFramesCount = 20 - FRAME_EXTENDS;
        int framesCount = forewardFramesCount * 2;
        if (frame >= forewardFramesCount) {
            frame = Math.abs(frame - framesCount);
        }
        float start = (float)frame * 0.05f;
        float end = start + (float)FRAME_EXTENDS * 0.05f;
        this.paintImpl(c, g, x, y, false, start, end);
    }

    protected final void paintDeterminate(Component c, Graphics g, int x, int y, float ratio) {
        this.paintImpl(c, g, x, y, true, 0.0f, ratio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void paintIdle(Component c, Graphics g, int x, int y) {
        Graphics2D g2d;
        if (this.isBackgroundPainted()) {
            g2d = (Graphics2D)g.create();
            try {
                g2d.translate(x, y);
                this.paintBackground(c, g2d);
            }
            finally {
                g2d.dispose();
            }
        }
        g2d = (Graphics2D)g.create();
        try {
            this.paintDecoratedIcon(c, g2d, x, y);
        }
        finally {
            g2d.dispose();
        }
    }

    public void setDelay(int delay) {
        float framesCount = 20 - FRAME_EXTENDS + 1;
        this.setUndeterminateFrameRate(Math.round((float)delay / framesCount), (20 - FRAME_EXTENDS) * 2);
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setBackgroundColor(Color color) {
        this.installDefaultBackgroundPainter(color);
    }

    public void setBackgroundPainter(Painter painter) {
        Painter old = this.getBackgroundPainter();
        this.backgroundPainter = painter;
        if (old != this.getBackgroundPainter()) {
            this.repaint(true);
        }
    }

    public Painter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    public void setBackgroundPainted(boolean value) {
        boolean old = this.isBackgroundPainted();
        this.backgroundPainted = value;
        if (old != this.isBackgroundPainted()) {
            this.repaint(true);
        }
    }

    public boolean isBackgroundPainted() {
        return this.backgroundPainted;
    }

    protected Rectangle getProgressBarBounds() {
        return this.barBounds;
    }

    protected void setProgressBarBounds(Rectangle bounds) {
        this.barBounds = bounds;
    }

    public void setProgressBarBackground(Paint background) {
        Paint old = this.barBackground;
        this.barBackground = background;
        if (old != this.barBackground) {
            this.repaint(true);
        }
    }

    public Paint getProgressBarBackground() {
        return this.barBackground;
    }

    public void setProgressBarForeground(Paint foreground) {
        Paint old = this.barForeground;
        this.barForeground = foreground;
        if (old != this.barForeground) {
            this.repaint(true);
        }
    }

    public Paint getProgressBarForeground() {
        return this.barForeground;
    }

    protected void installDefaultBackgroundPainter(Color color) {
        Color colorA = ColorUtilities.brighter((Color)color, (float)0.6f);
        Color colorB = color;
        LinearGradientPaint gradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, this.getIconHeight(), new float[]{0.2f, 0.8f}, new Color[]{colorA, colorB});
        RectanglePainter filler = new RectanglePainter(new Insets(0, 0, 0, 0), this.getIconWidth(), this.getIconHeight(), this.getIconWidth() / 4, this.getIconHeight() / 4, true, (Paint)gradient, 1.0f, (Paint)colorB);
        this.setBackgroundPainter((Painter)filler);
    }

    protected void installDefaultProgressBarColors() {
        this.setProgressBarBackground(this.createPaintUI("ProgressBar.background", this.getProgressBarBounds(), true));
        this.setProgressBarForeground(this.createPaintUI("ProgressBar.foreground", this.getProgressBarBounds(), true));
    }

    protected void installDefaultProgressBarBounds() {
        int barHeight = (int)((float)this.getIconHeight() * 0.12f);
        int barWidth = (int)((float)this.getIconWidth() * 0.8f);
        int barX = (this.getIconWidth() - barWidth) / 2;
        int barY = (int)((float)this.getIconHeight() * 0.75f);
        this.setProgressBarBounds(new Rectangle(barX, barY, barWidth, barHeight));
    }

    protected void paintBackground(Component c, Graphics g) {
        Painter painter = this.getBackgroundPainter();
        if (painter != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            painter.paint(g2d, null, this.getIconWidth(), this.getIconHeight());
        }
    }

    protected void paintProgressBar(Component c, Graphics g, Rectangle bounds, boolean determinate) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setPaint(this.barBackground);
        g2d.fillRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, bounds.height, bounds.height / 2);
    }

    protected void paintProgressBarAdvance(Component c, Graphics g, Rectangle bounds, boolean determinate, float start, float end) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int offset = Math.round((float)bounds.width * start);
        int length = Math.round((float)bounds.width * (end - start));
        if (offset < 0) {
            offset = 0;
        }
        if (offset + length > bounds.x + bounds.width) {
            length = bounds.x + bounds.width - offset;
        }
        g2d.setPaint(this.barForeground);
        g2d.fillRoundRect(bounds.x + offset, bounds.y, length, bounds.height, bounds.height, bounds.height / 2);
    }

    protected float getSignificantRatioOffset() {
        if (this.getDecoratedIcon() == null) {
            return 0.1f;
        }
        return 1.0f / (float)this.getProgressBarBounds().width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintImpl(Component c, Graphics g, int x, int y, boolean determinate, float start, float end) {
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            this.paintIdle(c, g, x, y);
        }
        finally {
            g2d.dispose();
        }
        g2d = (Graphics2D)g.create();
        try {
            g2d.translate(x, y);
            g2d.setClip(this.getProgressBarBounds());
            this.paintProgressBar(c, g, this.getProgressBarBounds(), determinate);
        }
        finally {
            g2d.dispose();
        }
        g2d = (Graphics2D)g.create();
        try {
            g2d.translate(x, y);
            g2d.setClip(this.getProgressBarBounds());
            this.paintProgressBarAdvance(c, g, this.getProgressBarBounds(), determinate, start, end);
        }
        finally {
            g2d.dispose();
        }
    }

    private Paint createPaintUI(String name, Rectangle bounds, boolean withShading) {
        Color color = UIManager.getColor(name);
        if (withShading) {
            return new LinearGradientPaint(0.0f, bounds.y, 0.0f, bounds.y + bounds.height, new float[]{0.5f, 1.0f}, new Color[]{ColorUtilities.brighter((Color)color, (float)0.3f), color});
        }
        return color;
    }
}

