/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.divxdede.swing.busy.icon.AbstractBusyIcon;

public abstract class DecoratorBusyIcon
extends AbstractBusyIcon {
    private Icon icon = null;
    private BufferedImage iconFrame = null;
    private FrameObserver frameObserver = new FrameObserver();
    private Insets insets = null;

    public DecoratorBusyIcon(Icon icon) {
        this(icon, null);
    }

    public DecoratorBusyIcon(Icon icon, Insets insets) {
        this.setDecoratedIcon(icon);
        this.setInsets(insets);
    }

    public Icon getDecoratedIcon() {
        return this.icon;
    }

    public synchronized void setDecoratedIcon(Icon icon) {
        if (this.icon == icon) {
            return;
        }
        if (this.icon instanceof ImageIcon) {
            ((ImageIcon)this.icon).setImageObserver(null);
        }
        if (this.icon instanceof Observable) {
            ((Observable)((Object)this.icon)).deleteObserver(this.frameObserver);
        }
        this.icon = icon;
        this.iconFrame = null;
        if (this.icon != null) {
            GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.iconFrame = gc.createCompatibleImage(this.icon.getIconWidth(), this.icon.getIconHeight(), 3);
            if (this.icon instanceof ImageIcon) {
                ((ImageIcon)this.icon).setImageObserver(this.frameObserver);
            }
            if (this.icon instanceof Observable) {
                ((Observable)((Object)this.icon)).addObserver(this.frameObserver);
            }
        }
        this.doIconFrameUpdate(null);
    }

    protected Insets getInsets() {
        return this.insets;
    }

    protected void setInsets(Insets insets) {
        this.insets = insets;
        this.repaint(true);
    }

    protected void paintIdle(Component c, Graphics g, int x, int y) {
        this.paintDecoratedIcon(c, g, x, y);
    }

    protected synchronized void paintDecoratedIcon(Component c, Graphics g, int x, int y) {
        if (this.iconFrame != null) {
            Insets margins = this.getInsets();
            if (margins != null) {
                x = margins.left;
                y = margins.top;
            }
            g.drawImage(this.iconFrame, x, y, null);
        }
    }

    public int getIconWidth() {
        int result;
        Icon icon = this.getDecoratedIcon();
        Insets margins = this.getInsets();
        int n = result = icon == null ? 0 : icon.getIconWidth();
        if (margins != null) {
            result += margins.left + margins.right;
        }
        return result;
    }

    public int getIconHeight() {
        int result;
        Icon icon = this.getDecoratedIcon();
        Insets margins = this.getInsets();
        int n = result = icon == null ? 0 : icon.getIconHeight();
        if (margins != null) {
            result += margins.top + margins.bottom;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doIconFrameUpdate(Image image) {
        if (this.iconFrame != null) {
            Graphics2D g = this.iconFrame.createGraphics();
            try {
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(0, 0, this.icon.getIconWidth(), this.icon.getIconHeight());
                g.setPaintMode();
                if (image != null) {
                    g.drawImage(image, 0, 0, null);
                } else {
                    this.icon.paintIcon(null, g, 0, 0);
                }
            }
            finally {
                g.dispose();
            }
        }
        this.repaint(true);
    }

    private class FrameObserver
    implements ImageObserver,
    Observer {
        private FrameObserver() {
        }

        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            if ((infoflags & 0x30) != 0) {
                DecoratorBusyIcon.this.doIconFrameUpdate(img);
            }
            return (infoflags & 0xA0) == 0;
        }

        public void update(Observable o, Object arg) {
            DecoratorBusyIcon.this.doIconFrameUpdate(null);
        }
    }
}

