/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import javax.swing.BoundedRangeModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.divxdede.swing.busy.BusyIcon;
import org.divxdede.swing.busy.BusyModel;

public abstract class AbstractBusyIcon
extends Observable
implements BusyIcon {
    private BoundedRangeModel model = null;
    private final ModelListener modelListener = new ModelListener();
    private final List<WeakReference<Component>> components = new LinkedList<WeakReference<Component>>();
    private BufferedImage cache = null;
    private float lastRatio = -1.0f;
    private int lastStateFlag = 0;
    private boolean discarded = false;
    private boolean useCache = true;
    private int undeterminateFrameRate = 0;
    private Timer undeterminateTimer = null;
    private final ActionListener undeterminateListener = new TimerListener();
    private int frameCount = 0;
    private int frame = 0;

    public AbstractBusyIcon() {
        this.undeterminateTimer = new Timer(0, this.undeterminateListener);
    }

    protected abstract void paintDeterminate(Component var1, Graphics var2, int var3, int var4, float var5);

    protected abstract void paintUndeterminate(Component var1, Graphics var2, int var3, int var4, int var5);

    protected abstract void paintIdle(Component var1, Graphics var2, int var3, int var4);

    protected abstract float getSignificantRatioOffset();

    public synchronized void setModel(BoundedRangeModel model) {
        if (this.getModel() != null) {
            this.getModel().removeChangeListener(this.modelListener);
        }
        this.model = model;
        if (this.getModel() != null) {
            this.getModel().addChangeListener(this.modelListener);
        }
    }

    public synchronized BoundedRangeModel getModel() {
        return this.model;
    }

    public boolean isDeterminate() {
        BusyModel m = this.getBusyModel();
        if (m != null) {
            return m.isDeterminate();
        }
        return this.getModel() != null;
    }

    public boolean isBusy() {
        BusyModel m = this.getBusyModel();
        if (m != null) {
            return m.isBusy();
        }
        return this.getModel() != null;
    }

    protected void setUndeterminateFrameRate(int delay, int frameCount) {
        this.undeterminateFrameRate = delay;
        this.frameCount = frameCount;
        this.refreshUndeterminateTimer();
    }

    public final void paintIcon(Component c, Graphics g, int x, int y) {
        BufferedImage offscreenImage;
        int nFrame;
        boolean isBusy;
        if (this.countObservers() == 0) {
            this.register(c);
        }
        boolean determinate = (isBusy = this.isBusy()) && this.isDeterminate();
        float ratio = determinate ? this.getRatio() : 0.0f;
        int n = nFrame = this.frame < 0 ? 0 : this.frame;
        if (!this.isCacheUpToDate(isBusy, determinate, ratio)) {
            if (this.useCache()) {
                offscreenImage = this.getCache();
                Graphics2D offscreen = offscreenImage.createGraphics();
                offscreen.setComposite(AlphaComposite.Clear);
                offscreen.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
                offscreen.setPaintMode();
                if (isBusy) {
                    if (determinate) {
                        this.paintDeterminate(c, offscreen, 0, 0, ratio);
                    } else {
                        this.paintUndeterminate(c, offscreen, 0, 0, nFrame);
                    }
                } else {
                    this.paintIdle(c, offscreen, 0, 0);
                }
                this.lastRatio = ratio;
                this.lastStateFlag = this.getStateFlag(isBusy, determinate);
                this.discarded = false;
            } else {
                if (isBusy) {
                    if (determinate) {
                        this.paintDeterminate(c, g, x, y, ratio);
                    } else {
                        this.paintUndeterminate(c, g, x, y, nFrame);
                    }
                } else {
                    this.paintIdle(c, g, x, y);
                }
                this.lastRatio = ratio;
                this.lastStateFlag = this.getStateFlag(isBusy, determinate);
                this.discarded = false;
                return;
            }
        }
        offscreenImage = this.getCache();
        g.drawImage(offscreenImage, x, y, c);
    }

    public synchronized boolean useCache() {
        return this.useCache;
    }

    public void setUseCache(boolean enable) {
        boolean oldValue = this.useCache();
        this.useCache = enable;
        if (oldValue != this.useCache()) {
            this.repaint(true);
        }
    }

    protected synchronized void repaint(boolean force) {
        if (!force) {
            if (this.isCacheUpToDate(this.isBusy(), this.isDeterminate(), this.getRatio())) {
                return;
            }
        } else {
            this.discarded = true;
        }
        Iterator<WeakReference<Component>> i = this.components.iterator();
        while (i.hasNext()) {
            WeakReference<Component> ref = i.next();
            Component comp = (Component)ref.get();
            if (comp == null) {
                i.remove();
                continue;
            }
            if (comp.isShowing()) {
                comp.repaint();
                continue;
            }
            i.remove();
        }
        this.setChanged();
        this.notifyObservers();
    }

    private BusyModel getBusyModel() {
        BoundedRangeModel m = this.getModel();
        if (m instanceof BusyModel) {
            return (BusyModel)m;
        }
        return null;
    }

    private boolean isCacheUpToDate(boolean isBusy, boolean determinate, float ratio) {
        int state = this.getStateFlag(isBusy, determinate);
        if (state != this.lastStateFlag) {
            return false;
        }
        if (determinate) {
            return this.useCache() && !this.discarded && this.lastRatio >= 0.0f && this.getRatioOffset(ratio) < this.getSignificantRatioOffset();
        }
        return this.useCache() && !this.discarded;
    }

    private synchronized BufferedImage getCache() {
        if (!this.useCache()) {
            return null;
        }
        if (this.cache == null || this.cache.getWidth() != this.getIconWidth() || this.cache.getHeight() != this.getIconHeight()) {
            GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.cache = gc.createCompatibleImage(this.getIconWidth(), this.getIconHeight(), 3);
        }
        return this.cache;
    }

    private float getRatio() {
        BoundedRangeModel brm = this.getModel();
        BusyModel busy = this.getBusyModel();
        if (busy != null) {
            if (!busy.isBusy()) {
                return 0.0f;
            }
            if (!busy.isDeterminate()) {
                return 0.0f;
            }
        }
        if (brm != null) {
            int length = brm.getMaximum() - brm.getMinimum();
            int value = brm.getValue() + brm.getExtent();
            return (float)value / (float)length;
        }
        return 0.0f;
    }

    private float getRatioOffset(float ratio) {
        return Math.abs(ratio - this.lastRatio);
    }

    private int getStateFlag(boolean isBusy, boolean isDeterminate) {
        return (isBusy ? 1 : 0) + (isDeterminate ? 2 : 0);
    }

    private synchronized void register(Component c) {
        Iterator<WeakReference<Component>> i = this.components.iterator();
        while (i.hasNext()) {
            WeakReference<Component> ref = i.next();
            Component comp = (Component)ref.get();
            if (comp == null) {
                i.remove();
            }
            if (comp != c) continue;
            return;
        }
        this.components.add(new WeakReference<Component>(c));
    }

    private boolean refreshUndeterminateTimer() {
        boolean timerEnabled;
        boolean bl = timerEnabled = this.isBusy() && !this.isDeterminate() && this.undeterminateFrameRate > 0;
        if (timerEnabled) {
            this.undeterminateTimer.setDelay(this.undeterminateFrameRate);
            if (!this.undeterminateTimer.isRunning()) {
                this.frame = -1;
                this.undeterminateTimer.start();
                return true;
            }
        } else if (this.undeterminateTimer.isRunning()) {
            this.undeterminateTimer.stop();
            return true;
        }
        return false;
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractBusyIcon.this.frame++;
            if (AbstractBusyIcon.this.frame >= AbstractBusyIcon.this.frameCount) {
                AbstractBusyIcon.this.frame = 0;
            }
            AbstractBusyIcon.this.repaint(true);
        }
    }

    private class ModelListener
    implements ChangeListener {
        private ModelListener() {
        }

        public void stateChanged(ChangeEvent e) {
            BoundedRangeModel model = AbstractBusyIcon.this.getModel();
            boolean force = AbstractBusyIcon.this.refreshUndeterminateTimer();
            if (model != null && model.getValue() == model.getMaximum() && AbstractBusyIcon.this.lastRatio < 1.0f) {
                force = true;
            }
            AbstractBusyIcon.this.repaint(force);
        }
    }
}

