/*
 * Decompiled with CFR 0.152.
 */
package org.divxdede.swing.busy;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import org.divxdede.swing.busy.BusyModel;
import org.divxdede.swing.busy.DefaultBusyModel;
import org.divxdede.swing.busy.ui.BasicBusyLayerUI;
import org.divxdede.swing.busy.ui.BusyLayerUI;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.LayerUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBusyComponent<C extends JComponent>
extends JComponent
implements Scrollable {
    private JXLayer<JComponent> layer = null;
    private BusyLayerUI ui = null;

    public JBusyComponent() {
        this(null);
    }

    public JBusyComponent(C view) {
        this(view, new BasicBusyLayerUI());
    }

    public JBusyComponent(C view, BusyLayerUI ui) {
        this.layer = new JXLayer(view);
        super.setLayout(new BorderLayout());
        super.add((Component)this.layer);
        super.setOpaque(false);
        this.setBusyLayerUI(ui);
        this.setBusyModel(new DefaultBusyModel());
    }

    public C getView() {
        return (C)((JComponent)this.layer.getView());
    }

    public void setView(C view) {
        this.layer.setView(view);
    }

    public BusyLayerUI getBusyLayerUI() {
        return this.ui;
    }

    public void setBusyLayerUI(BusyLayerUI newUI) {
        if (newUI == null) {
            newUI = new BasicBusyLayerUI();
        } else if (!(newUI instanceof LayerUI)) {
            throw new IllegalArgumentException("newUI must subclass LayerUI");
        }
        BusyModel model = null;
        if (this.getBusyLayerUI() != null) {
            model = this.getBusyLayerUI().getBusyModel();
            this.getBusyLayerUI().setBusyModel(null);
        }
        this.ui = newUI;
        this.layer.setUI((LayerUI)this.getBusyLayerUI());
        if (this.getBusyLayerUI() != null) {
            this.getBusyLayerUI().setBusyModel(model);
        }
    }

    public void setBusyModel(BusyModel model) {
        BusyLayerUI myUI = this.getBusyLayerUI();
        if (myUI == null) {
            throw new IllegalStateException("Can't set a BusyModel on a JBusyComponent without a BusyLayerUI");
        }
        myUI.setBusyModel(model);
    }

    public BusyModel getBusyModel() {
        BusyLayerUI myUI = this.getBusyLayerUI();
        if (myUI == null) {
            return null;
        }
        return myUI.getBusyModel();
    }

    public boolean isBusy() {
        return this.getBusyModel() != null && this.getBusyModel().isBusy();
    }

    public void setBusy(boolean value) {
        BusyModel model = this.getBusyModel();
        if (model != null) {
            model.setBusy(value);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.getView() instanceof Scrollable) {
            return ((Scrollable)this.getView()).getPreferredScrollableViewportSize();
        }
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.getView() instanceof Scrollable) {
            return ((Scrollable)this.getView()).getScrollableUnitIncrement(visibleRect, orientation, direction);
        }
        return 1;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.getView() instanceof Scrollable) {
            return ((Scrollable)this.getView()).getScrollableBlockIncrement(visibleRect, orientation, direction);
        }
        return 1;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getView() instanceof Scrollable) {
            return ((Scrollable)this.getView()).getScrollableTracksViewportWidth();
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getView() instanceof Scrollable) {
            return ((Scrollable)this.getView()).getScrollableTracksViewportHeight();
        }
        return false;
    }

    @Override
    public Component add(Component comp) {
        throw new UnsupportedOperationException("JBusyComponent.add() is not supported.");
    }

    @Override
    public void remove(Component comp) {
        throw new UnsupportedOperationException("JBusyComponent.remove(Component) is not supported.");
    }

    @Override
    public void removeAll() {
        throw new UnsupportedOperationException("JBusyComponent.removeAll() is not supported.");
    }
}

